/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.memory.command;

import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.memory.command.AllocationTraceType;

public final class AllocationTraceConfiguration {
    private AllocationTraceType type;
    private int maxStackTraceSize;
    private boolean includeLineNrs;
    private String allocatedObjectClassFilter;
    private ThreadFilter allocatedObjectThreadFilter;
    private boolean allowPacketReordering;
    private boolean allowMultiEvents;
    private boolean hideStringResolving;
    private boolean hideFinalizerAllocation;
    private boolean hideStaticInitializers;
    private boolean hideClassLoading;
    private int minSize;
    private int maxSize;
    private int increaseCount;
    private int traceEveryNth;
    private boolean onlyTopPhysicalFrame;
    private boolean includeInlineCount;
    private boolean useBci;
    private boolean useNonZeroBci;
    private boolean supportJRuby;

    public AllocationTraceConfiguration(AllocationTraceType type) {
        this.type = type;
        this.maxStackTraceSize = -1;
        this.includeLineNrs = true;
        this.allocatedObjectClassFilter = "**";
        this.allocatedObjectThreadFilter = new ThreadFilter();
        this.allowPacketReordering = false;
        this.allowMultiEvents = false;
        this.hideStringResolving = false;
        this.hideFinalizerAllocation = false;
        this.hideStaticInitializers = false;
        this.hideClassLoading = false;
        this.minSize = 32;
        this.maxSize = 65535;
        this.traceEveryNth = 0;
        this.onlyTopPhysicalFrame = false;
        this.supportJRuby = false;
    }

    public void setType(AllocationTraceType type) {
        this.type = type;
    }

    public AllocationTraceType getType() {
        return this.type;
    }

    public void setMaxStackTraceSize(int size) {
        if (size < -1) {
            throw new IllegalArgumentException("Invalid size " + size);
        }
        this.maxStackTraceSize = size;
    }

    public int getMaxStackTraceSize() {
        return this.maxStackTraceSize;
    }

    public void setIncludeLineNrs(boolean includeLineNrs) {
        this.includeLineNrs = includeLineNrs;
    }

    public boolean isIncludingLineNrs() {
        return this.includeLineNrs;
    }

    public void setAllocatedObjectClassFilter(String filter) {
        this.allocatedObjectClassFilter = filter == null ? "*" : filter;
    }

    public boolean hasAllocatedObjectClassFilter() {
        return this.allocatedObjectClassFilter.length() > 0 && !"*".equals(this.allocatedObjectClassFilter);
    }

    public String getAllocatedObjectClassFilter() {
        return this.allocatedObjectClassFilter;
    }

    public void setAllocatedObjectThreadFilter(ThreadFilter filter) {
        this.allocatedObjectThreadFilter = filter == null ? new ThreadFilter() : filter;
    }

    public ThreadFilter getAllocatedObjectThreadFilter() {
        return this.allocatedObjectThreadFilter;
    }

    public void setAllowPacketReordering(boolean allowPacketReordering) {
        this.allowPacketReordering = allowPacketReordering;
    }

    public boolean isAllowingPacketReordering() {
        return this.allowPacketReordering;
    }

    public void setAllowMultiEvents(boolean allowMultiEvents) {
        this.allowMultiEvents = allowMultiEvents;
    }

    public boolean isAllowingMultiEvents() {
        return this.allowMultiEvents;
    }

    public void setHideStringResolving(boolean hideStringResolving) {
        this.hideStringResolving = hideStringResolving;
    }

    public boolean isHidingStringResolving() {
        return this.hideStringResolving;
    }

    public void setHideFinalizerAllocation(boolean hideFinalizerAllocation) {
        this.hideFinalizerAllocation = hideFinalizerAllocation;
    }

    public boolean isHidingFinalizerAllocation() {
        return this.hideFinalizerAllocation;
    }

    public void setHideStaticInitializers(boolean hideStaticInitializers) {
        this.hideStaticInitializers = hideStaticInitializers;
    }

    public boolean isHidingStaticInitializers() {
        return this.hideStaticInitializers;
    }

    public void setHideClassLoading(boolean hideClassLoading) {
        this.hideClassLoading = hideClassLoading;
    }

    public boolean isHidingClassLoading() {
        return this.hideClassLoading;
    }

    public int getMinSize() {
        return this.minSize;
    }

    public void setMinSize(int minSize) {
        this.minSize = minSize;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getIncreaseCount() {
        return this.increaseCount;
    }

    public void setIncreaseCount(int increaseCount) {
        this.increaseCount = increaseCount;
    }

    public int getTraceEveryNth() {
        return this.traceEveryNth;
    }

    public void setTraceEveryNth(int traceEveryNth) {
        this.traceEveryNth = traceEveryNth;
    }

    public boolean getOnlyTopPhysicalFrame() {
        return this.onlyTopPhysicalFrame;
    }

    public void setOnlyTopPhysicalFrame(boolean onlyTopPhysicalFrame) {
        this.onlyTopPhysicalFrame = onlyTopPhysicalFrame;
    }

    public boolean includeInlineCount() {
        return this.includeInlineCount;
    }

    public void setIncludeInlineCount(boolean includeInlineCount) {
        this.includeInlineCount = includeInlineCount;
    }

    public boolean useBci() {
        return this.useBci;
    }

    public void setUseBci(boolean useBci) {
        this.useBci = useBci;
    }

    public boolean useNonZeroBci() {
        return this.useNonZeroBci;
    }

    public void setUseNonZeroBci(boolean useNonZeroBci) {
        this.useNonZeroBci = useNonZeroBci;
    }

    public boolean supportsJRuby() {
        return this.supportJRuby;
    }

    public void setSupportsJRuby(boolean supportJRuby) {
        this.supportJRuby = supportJRuby;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof AllocationTraceConfiguration)) {
            return false;
        }
        AllocationTraceConfiguration config = (AllocationTraceConfiguration)obj;
        return config.includeLineNrs == this.includeLineNrs && config.allowPacketReordering == this.allowPacketReordering && config.allowMultiEvents == this.allowMultiEvents && config.hideStringResolving == this.hideStringResolving && config.hideFinalizerAllocation == this.hideFinalizerAllocation && config.hideClassLoading == this.hideClassLoading && config.hideStaticInitializers == this.hideStaticInitializers && config.maxStackTraceSize == this.maxStackTraceSize && config.maxSize == this.maxSize && config.minSize == this.minSize && config.traceEveryNth == this.traceEveryNth && config.onlyTopPhysicalFrame == this.onlyTopPhysicalFrame && config.includeInlineCount == this.includeInlineCount && config.useBci == this.useBci && config.useNonZeroBci == this.useNonZeroBci && config.allocatedObjectClassFilter.equals(this.allocatedObjectClassFilter) && config.allocatedObjectThreadFilter.equals(this.allocatedObjectThreadFilter) && config.supportJRuby == this.supportJRuby;
    }

    public int hashCode() {
        int retValue = 255;
        retValue ^= this.includeLineNrs ? 1 : 0;
        retValue ^= this.allowPacketReordering ? 2 : 0;
        retValue ^= this.allowMultiEvents ? 4 : 0;
        retValue ^= this.hideStringResolving ? 8 : 0;
        retValue ^= this.hideFinalizerAllocation ? 16 : 0;
        retValue ^= this.hideClassLoading ? 32 : 0;
        retValue ^= this.hideStaticInitializers ? 64 : 0;
        retValue ^= this.maxStackTraceSize;
        retValue ^= this.minSize;
        retValue ^= this.maxSize;
        retValue ^= this.type.hashCode();
        retValue ^= this.allocatedObjectClassFilter.hashCode();
        retValue ^= this.allocatedObjectThreadFilter.hashCode();
        retValue ^= this.traceEveryNth;
        retValue ^= this.onlyTopPhysicalFrame ? 128 : 0;
        retValue ^= this.includeInlineCount ? 256 : 0;
        retValue ^= this.useBci ? 512 : 0;
        retValue ^= this.useNonZeroBci ? 1024 : 0;
        return retValue ^= this.supportJRuby ? 2048 : 0;
    }
}

