/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.memory.event;

import com.sap.jvm.profiling.i18n.I18n;

public enum GcCause {
    UNKNOWN_CAUSE("Unknown cause", I18n._tss(I18n.TextType.XMSG, "GC cause", "Unknown cause"), I18n._ts(I18n.TextType.XTOL, "Unknown cause")),
    JAVA_LANG_SYSTEM_GC("System.gc()", I18n._tss(I18n.TextType.XMSG, "GC cause", "System.gc()"), I18n._ts(I18n.TextType.XTOL, "The GC was requested explicitely (e.g. by System.gc()).")),
    FULL_GC_ALOT("FullGCAlot", I18n._tss(I18n.TextType.XMSG, "GC cause", "FullGCAlot"), I18n._ts(I18n.TextType.XTOL, "One of the extra GCs when -XX:+FullGCALot option was given.")),
    SCAVENGE_ALOT("ScavengeAlot", I18n._tss(I18n.TextType.XMSG, "GC cause", "ScavengeAlot"), I18n._ts(I18n.TextType.XTOL, "One of the extra partial GCs when -XX:+ScavengeAlot option was given.")),
    ALLOCATION_PROFILER("Allocation Profiler", I18n._tss(I18n.TextType.XMSG, "GC cause", "Allocation Profiler"), I18n._ts(I18n.TextType.XTOL, "A GC triggered by the allocation profiler (enabled by the -Xaprof option).")),
    JVMTI_FORCE_GC("JVMTI", I18n._tss(I18n.TextType.XMSG, "GC cause", "JVMTI"), I18n._ts(I18n.TextType.XTOL, "A GC forced by a JVMTI agent.")),
    GC_LOCKER("GC Locker", I18n._tss(I18n.TextType.XMSG, "GC cause", "GC Locker"), I18n._ts(I18n.TextType.XTOL, "A GC was triggered, but one thread was in a JNI method with an active call to GetPrimitiveArrayCritical. After the critical section of the JNI method was left, this GC was triggered.")),
    HEAP_INSPECTION("Heap Inspection", I18n._tss(I18n.TextType.XMSG, "GC cause", "Heap Inspection"), I18n._ts(I18n.TextType.XTOL, "The GC was initiated to produce a class statistic via the -XX:+PrintClassHistogram flag.")),
    HEAP_DUMP("Heap Dump", I18n._tss(I18n.TextType.XMSG, "GC cause", "Heap Dump"), I18n._ts(I18n.TextType.XTOL, "The GC was initiated to produce a heap dump.")),
    NO_GC("No GC", I18n._tss(I18n.TextType.XMSG, "GC cause", "No GC"), I18n._ts(I18n.TextType.XTOL, "Initialization value of the GC cause")),
    NO_CAUSE_SPECIFIED("No GC Cause", I18n._tss(I18n.TextType.XMSG, "GC cause", "No GC Cause"), I18n._ts(I18n.TextType.XTOL, "No GC cause was specified.")),
    ALLOCATION_FAILURE("Allocation Failure", I18n._tss(I18n.TextType.XMSG, "GC cause", "Allocation Failure"), I18n._ts(I18n.TextType.XTOL, "An allocation of a Java object failed. This is the most probable cause of a GC.")),
    TENURED_GENERATION_FULL("Old Gen. Full", I18n._tss(I18n.TextType.XMSG, "GC cause", "Old Gen. Full"), I18n._ts(I18n.TextType.XTOL, "An allocation in the tenured generation failed.")),
    PERMANENT_GENERATION_FULL("Metaspace Full", I18n._tss(I18n.TextType.XMSG, "GC cause", "Metaspace Full"), I18n._ts(I18n.TextType.XTOL, "An allocation in the metaspace failed.")),
    CMS_GENERATION_FULL("CMS Gen. Full", I18n._tss(I18n.TextType.XMSG, "GC cause", "CMS Gen. Full"), I18n._ts(I18n.TextType.XTOL, "An allocation in the CMS generation failed.")),
    CMS_INTERNAL_MARK("CMS Initial Mark", I18n._tss(I18n.TextType.XMSG, "GC cause", "CMS Initial Mark"), I18n._ts(I18n.TextType.XTOL, "The GC was triggered as part of the initial marking of CMS.")),
    CMS_FINAL_MARK("CMS Final Remark", I18n._tss(I18n.TextType.XMSG, "GC cause", "CMS Final Remark"), I18n._ts(I18n.TextType.XTOL, "The GC was triggered as part of the final marking of CMS.")),
    OLD_GEN_EXP_ON_LAST_SCAVENGE("Old Gen. Expanded", I18n._tss(I18n.TextType.XMSG, "GC cause", "Old Gen. Expanded"), I18n._ts(I18n.TextType.XTOL, "The old generation expanded during the last partial GC.")),
    OLD_GEN_TOO_FULL_TO_SCAVENGE("Old Gen. Too Full", I18n._tss(I18n.TextType.XMSG, "GC cause", "Old Gen. Too Full"), I18n._ts(I18n.TextType.XTOL, "The old generation was too full for a partial GC.")),
    ADAPTIVE_SIZE_POLICY("Adaptive size policy", I18n._tss(I18n.TextType.XMSG, "GC cause", "Adaptive size policy"), I18n._ts(I18n.TextType.XTOL, "The adaptive size policy decided that a full GC should be done instead of a partial GC.")),
    LAST_DITCH_COLLECTION("Last ditch collection", I18n._tss(I18n.TextType.XMSG, "GC cause", "Last ditch collection"), I18n._ts(I18n.TextType.XTOL, "All previous attempts to clear enough memory for an object allocation failed. This is the last attempt before an OutOfMemoryError is thrown.")),
    FORCED_MAXIMUM_COMPACTION("Forced max compaction", I18n._tss(I18n.TextType.XMSG, "GC cause", "Forced max compaction"), I18n._ts(I18n.TextType.XTOL, "A maximum heap compaction GC forced externally (e.g. by the JVMMon).")),
    ALLOCATION_STATISTIC_REQUESTED("Allocation Statistic", I18n._tss(I18n.TextType.XMSG, "GC cause", "Allocation Statistic"), I18n._ts(I18n.TextType.XTOL, "A GC was forced because an allocation statistic was requested.")),
    CLASS_STATISTIC_REQUESTED("Class Statistic", I18n._tss(I18n.TextType.XMSG, "GC cause", "Class Statistic"), I18n._ts(I18n.TextType.XTOL, "A GC was forced because a class statistic was requested.")),
    CMS_OLD_GENERATION_LOW_MEMORY("CMS Old Generation", I18n._tss(I18n.TextType.XMSG, "GC cause", "CMS Old Generation"), I18n._ts(I18n.TextType.XTOL, "A concurrent GC was initiated because the old generation is running low on memory.")),
    CMS_PERM_GENERATION_LOW_MEMORY("CMS Perm Generation", I18n._tss(I18n.TextType.XMSG, "GC cause", "CMS Perm Generation"), I18n._ts(I18n.TextType.XTOL, "A concurrent GC was initiated because the perm generation is running low on memory.")),
    CMS_BOOTSTRAP_TIMERS("CMS bootstrapping", I18n._tss(I18n.TextType.XMSG, "GC cause", "CMS bootstrapping"), I18n._ts(I18n.TextType.XTOL, "A concurrent GC was initiated to bootstrap the CMS timers.")),
    LAST_GC_CAUSE("ILLEGAL VALUE", I18n._tss(I18n.TextType.XMSG, "GC cause", "ILLEGAL VALUE"), I18n._ts(I18n.TextType.XTOL, "ILLEGAL VALUE - last gc cause - ILLEGAL VALUE")),
    G1_INC_COLLECTION_PAUSE("G1 Evacuation Pause", I18n._tss(I18n.TextType.XMSG, "GC cause", "G1 Evacuation Pause"), I18n._ts(I18n.TextType.XTOL, "An allocation of a Java object failed causing an incremental GC.")),
    G1_JAVA_HEAP_LOW_MEMORY("G1 Heap low on memory", I18n._tss(I18n.TextType.XMSG, "GC cause", "G1 Heap low on memory"), I18n._ts(I18n.TextType.XTOL, "A concurrent marking was initiated because the Java heap is running low on memory.")),
    G1_HUMONGOUS_ALLOCATION("G1 Huge Allocation", I18n._tss(I18n.TextType.XMSG, "GC cause", "G1 Huge Allocation"), I18n._ts(I18n.TextType.XTOL, "An allocation of a humongous Java object occured.")),
    METASPACE_FULL("Metaspace Full", I18n._tss(I18n.TextType.XMSG, "GC cause", "Metaspace Full"), I18n._ts(I18n.TextType.XTOL, "An allocation in the metaspace failed.")),
    CMS_METASPACE_LOW_MEMORY("CMS Metaspace", I18n._tss(I18n.TextType.XMSG, "GC cause", "CMS Metaspace"), I18n._ts(I18n.TextType.XTOL, "A concurrent GC was initiated because the metaspace is running low on memory.")),
    CMS_CONCURRENT_MARK("CMS Concurrent Mark", I18n._tss(I18n.TextType.XMSG, "GC cause", "CMS Concurrent Mark"), I18n._ts(I18n.TextType.XTOL, "A concurrent marking GC was initiated.")),
    WB_YOUNG_GC("WhiteBox Initiated Young GC", I18n._tss(I18n.TextType.XMSG, "GC cause", "WhiteBox Initiated Young GC"), I18n._ts(I18n.TextType.XTOL, "The young GC was initiated by a WhiteBox test.")),
    WB_CONC_MARC("WhiteBox Initiated Concurrent Mark", I18n._tss(I18n.TextType.XMSG, "GC cause", "WhiteBox Initiated Concurrent Mark"), I18n._ts(I18n.TextType.XTOL, "The conc. marking was initiated by a WhiteBox test.")),
    WB_FULL_GC("WhiteBox Initiated Full GC", I18n._tss(I18n.TextType.XMSG, "GC cause", "WhiteBox Initiated Full GC"), I18n._ts(I18n.TextType.XTOL, "The full GC was initiated by a WhiteBox test.")),
    UPDATE_ALLOC_CONTEXT_STATS_INC("Update Allocation Context Stats Inc", I18n._tss(I18n.TextType.XMSG, "GC cause", "Update Allocation Context Stats Inc"), I18n._ts(I18n.TextType.XTOL, "Update Allocation Context Stats Inc")),
    UPDATE_ALLOC_CONTEXT_STATS_FULL("Update Allocation Context Stats Full", I18n._tss(I18n.TextType.XMSG, "GC cause", "Update Allocation Context Stats Full"), I18n._ts(I18n.TextType.XTOL, "Update Allocation Context Stats Full")),
    METADATA_GC_CLEAR_SOFT_REFS("Metasp. full, clear soft refs", I18n._tss(I18n.TextType.XMSG, "GC cause", "Metasp. full, clear soft refs"), I18n._ts(I18n.TextType.XTOL, "An allocation in the metaspace failed, clear all soft references.")),
    DCMD_GC_RUN("Diagnostic Command", I18n._tss(I18n.TextType.XMSG, "GC cause", "Diagnostic Command"), I18n._ts(I18n.TextType.XTOL, "The GC run was initiated by a diagnostic command"));

    private final String description;
    private final String displayShort;
    private final String displayLong;

    private GcCause(String description, String displayShort, String displayLong) {
        this.description = description;
        this.displayShort = displayShort;
        this.displayLong = displayLong;
    }

    public String getDescription() {
        return this.description;
    }

    public String getShortDescrDisplay() {
        return this.displayShort;
    }

    public String getLongDescrDisplay() {
        return this.displayLong;
    }

    public static GcCause get(int value) {
        switch (value) {
            case 0: {
                return JAVA_LANG_SYSTEM_GC;
            }
            case 1: {
                return FULL_GC_ALOT;
            }
            case 2: {
                return SCAVENGE_ALOT;
            }
            case 3: {
                return ALLOCATION_PROFILER;
            }
            case 4: {
                return JVMTI_FORCE_GC;
            }
            case 5: {
                return GC_LOCKER;
            }
            case 6: {
                return HEAP_INSPECTION;
            }
            case 7: {
                return HEAP_DUMP;
            }
            case 8: {
                return NO_GC;
            }
            case 9: {
                return NO_CAUSE_SPECIFIED;
            }
            case 10: {
                return ALLOCATION_FAILURE;
            }
            case 11: {
                return TENURED_GENERATION_FULL;
            }
            case 12: {
                return PERMANENT_GENERATION_FULL;
            }
            case 13: {
                return CMS_GENERATION_FULL;
            }
            case 14: {
                return CMS_INTERNAL_MARK;
            }
            case 15: {
                return CMS_FINAL_MARK;
            }
            case 16: {
                return OLD_GEN_EXP_ON_LAST_SCAVENGE;
            }
            case 17: {
                return OLD_GEN_TOO_FULL_TO_SCAVENGE;
            }
            case 18: {
                return ADAPTIVE_SIZE_POLICY;
            }
            case 19: {
                return LAST_DITCH_COLLECTION;
            }
            case 20: {
                return FORCED_MAXIMUM_COMPACTION;
            }
            case 21: {
                return ALLOCATION_STATISTIC_REQUESTED;
            }
            case 22: {
                return CLASS_STATISTIC_REQUESTED;
            }
            case 23: {
                return CMS_OLD_GENERATION_LOW_MEMORY;
            }
            case 24: {
                return CMS_PERM_GENERATION_LOW_MEMORY;
            }
            case 25: {
                return CMS_BOOTSTRAP_TIMERS;
            }
            case 26: {
                return LAST_GC_CAUSE;
            }
            case 27: {
                return G1_INC_COLLECTION_PAUSE;
            }
            case 28: {
                return G1_JAVA_HEAP_LOW_MEMORY;
            }
            case 29: {
                return G1_HUMONGOUS_ALLOCATION;
            }
            case 30: {
                return METASPACE_FULL;
            }
            case 31: {
                return CMS_METASPACE_LOW_MEMORY;
            }
            case 32: {
                return CMS_CONCURRENT_MARK;
            }
            case 33: {
                return WB_YOUNG_GC;
            }
            case 34: {
                return WB_CONC_MARC;
            }
            case 35: {
                return WB_FULL_GC;
            }
            case 36: {
                return UPDATE_ALLOC_CONTEXT_STATS_INC;
            }
            case 37: {
                return UPDATE_ALLOC_CONTEXT_STATS_FULL;
            }
            case 38: {
                return METADATA_GC_CLEAR_SOFT_REFS;
            }
            case 39: {
                return DCMD_GC_RUN;
            }
        }
        return UNKNOWN_CAUSE;
    }

    public static int get(GcCause value) {
        switch (value) {
            case JAVA_LANG_SYSTEM_GC: {
                return 0;
            }
            case FULL_GC_ALOT: {
                return 1;
            }
            case SCAVENGE_ALOT: {
                return 2;
            }
            case ALLOCATION_PROFILER: {
                return 3;
            }
            case JVMTI_FORCE_GC: {
                return 4;
            }
            case GC_LOCKER: {
                return 5;
            }
            case HEAP_INSPECTION: {
                return 6;
            }
            case HEAP_DUMP: {
                return 7;
            }
            case NO_GC: {
                return 8;
            }
            case NO_CAUSE_SPECIFIED: {
                return 9;
            }
            case ALLOCATION_FAILURE: {
                return 10;
            }
            case TENURED_GENERATION_FULL: {
                return 11;
            }
            case PERMANENT_GENERATION_FULL: {
                return 12;
            }
            case CMS_GENERATION_FULL: {
                return 13;
            }
            case CMS_INTERNAL_MARK: {
                return 14;
            }
            case CMS_FINAL_MARK: {
                return 15;
            }
            case OLD_GEN_EXP_ON_LAST_SCAVENGE: {
                return 16;
            }
            case OLD_GEN_TOO_FULL_TO_SCAVENGE: {
                return 17;
            }
            case ADAPTIVE_SIZE_POLICY: {
                return 18;
            }
            case LAST_DITCH_COLLECTION: {
                return 19;
            }
            case FORCED_MAXIMUM_COMPACTION: {
                return 20;
            }
            case ALLOCATION_STATISTIC_REQUESTED: {
                return 21;
            }
            case CLASS_STATISTIC_REQUESTED: {
                return 22;
            }
            case CMS_OLD_GENERATION_LOW_MEMORY: {
                return 23;
            }
            case CMS_PERM_GENERATION_LOW_MEMORY: {
                return 24;
            }
            case CMS_BOOTSTRAP_TIMERS: {
                return 25;
            }
            case LAST_GC_CAUSE: {
                return 26;
            }
            case G1_INC_COLLECTION_PAUSE: {
                return 27;
            }
            case G1_JAVA_HEAP_LOW_MEMORY: {
                return 28;
            }
            case G1_HUMONGOUS_ALLOCATION: {
                return 29;
            }
            case METASPACE_FULL: {
                return 30;
            }
            case CMS_METASPACE_LOW_MEMORY: {
                return 31;
            }
            case CMS_CONCURRENT_MARK: {
                return 32;
            }
            case WB_YOUNG_GC: {
                return 33;
            }
            case WB_CONC_MARC: {
                return 34;
            }
            case WB_FULL_GC: {
                return 35;
            }
            case UPDATE_ALLOC_CONTEXT_STATS_INC: {
                return 36;
            }
            case UPDATE_ALLOC_CONTEXT_STATS_FULL: {
                return 37;
            }
            case METADATA_GC_CLEAR_SOFT_REFS: {
                return 38;
            }
            case DCMD_GC_RUN: {
                return 39;
            }
        }
        return -1;
    }
}

