/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.memory.event;

import com.sap.jvm.profiling.i18n.I18n;

public enum GcEventType {
    PARALLEL_GC_SCAVENGE("Parallel scavenge (partial GC)", I18n._tss(I18n.TextType.XMSG, "GC event", "Parallel scavenge (partial GC)"), I18n._ts(I18n.TextType.XTOL, "A parallel scavenge (partial GC) in a parallel GC.")),
    SKIPPED_PARALLEL_GC_SCAVENGE("Skipped parallel scavenge (partial GC)", I18n._tss(I18n.TextType.XMSG, "GC event", "Skipped parallel scavenge (partial GC)"), I18n._ts(I18n.TextType.XTOL, "A skipped parallel scavenge (partial GC) in a parallel GC.")),
    PARALLEL_GC_MARK_SWEEP("Serial mark sweep (full GC)", I18n._tss(I18n.TextType.XMSG, "GC event", "Serial mark sweep (full GC)"), I18n._ts(I18n.TextType.XTOL, "A serial mark sweep (full GC) in a parallel GC.")),
    SKIPPED_PARALLEL_GC_MARK_SWEEP("Skipped serial mark sweep (full GC)", I18n._tss(I18n.TextType.XMSG, "GC event", "Skipped serial mark sweep (full GC)"), I18n._ts(I18n.TextType.XTOL, "A skipped serial mark sweep (full GC) in a parallel GC.")),
    PARALLEL_GC_PARALLEL_COMPACT("Parallel compact (full GC)", I18n._tss(I18n.TextType.XMSG, "GC event", "Parallel compact (full GC)"), I18n._ts(I18n.TextType.XTOL, "A parallel mark compact (full GC) in a parallel GC.")),
    PARALLEL_GC_SMALL_FORCED_FULL_GC("Partial GC triggering full GC due to expected promotion failure at next GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Partial GC triggering full GC due to expected promotion failure at next GC"), I18n._ts(I18n.TextType.XTOL, "A partial GC triggered a full GC in a parallel GC, because it is expected that the promotion will fail in the next partial GC.")),
    SKIPPED_PARALLEL_GC_PARALLEL_COMPACT("Skipped parallel compact (full GC)", I18n._tss(I18n.TextType.XMSG, "GC event", "Skipped parallel compact (full GC)"), I18n._ts(I18n.TextType.XTOL, "A skipped parallel mark compact (full GC) in a parallel GC.")),
    SERIAL_NEW_GC("Serial partial GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Serial partial GC"), I18n._ts(I18n.TextType.XTOL, "A serial scavenge (partial GC) in a serial GC.")),
    SKIPPED_SERIAL_NEW_GC("Skipped serial partial GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Skipped serial partial GC"), I18n._ts(I18n.TextType.XTOL, "A skipped serial scavenge (partial GC) in a serial GC.")),
    PARALLEL_NEW_GC("Parallel partial GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Parallel partial GC"), I18n._ts(I18n.TextType.XTOL, "A parallel scavenge (partial GC) in a parallel GC.")),
    SKIPPED_PARALLEL_NEW_GC("Skipped parallel partial GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Skipped parallel partial GC"), I18n._ts(I18n.TextType.XTOL, "A skipped parallel scavenge (partial GC) in a parallel GC.")),
    TENURED_GC("Tenured generation GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Tenured generation GC"), I18n._ts(I18n.TextType.XTOL, "A tenured GC (full GC) in a parallel or serial GC.")),
    SKIPPED_TENURED_GC("Skipped tenured generation GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Skipped tenured generation GC"), I18n._ts(I18n.TextType.XTOL, "A skipped tenured GC (full GC) in a parallel or serial GC.")),
    YOUNG_GEN_REF_HANDLING("Young generation reference handling", I18n._tss(I18n.TextType.XMSG, "GC event", "Young generation reference handling"), I18n._ts(I18n.TextType.XTOL, "A reference processing event of a young generation.")),
    ALL_GEN_REF_HANDLING("Reference handling during full GC (all generations)", I18n._tss(I18n.TextType.XMSG, "GC event", "Reference handling during full GC (all generations)"), I18n._ts(I18n.TextType.XTOL, "A reference processing event of all generations.")),
    OLD_GEN_REF_HANDLING("Old generation reference handling", I18n._tss(I18n.TextType.XMSG, "GC event", "Old generation reference handling"), I18n._ts(I18n.TextType.XTOL, "A reference processing event of an old generation.")),
    CMS_INITIAL_MARKING("CMS (stop-the-world) initial marking phase", I18n._tss(I18n.TextType.XMSG, "GC event", "CMS (stop-the-world) initial marking phase"), I18n._ts(I18n.TextType.XTOL, "The (stop-the-world) initial marking phase of the concurrent mark sweep GC.")),
    CMS_MARKING("CMS (potentially concurrent) marking phase", I18n._tss(I18n.TextType.XMSG, "GC event", "CMS (potentially concurrent) marking phase"), I18n._ts(I18n.TextType.XTOL, "The (potentially concurrent) marking phase of the concurrent mark sweep GC.")),
    CMS_PRECLEANING("CMS concurrent precleaning phase", I18n._tss(I18n.TextType.XMSG, "GC event", "CMS concurrent precleaning phase"), I18n._ts(I18n.TextType.XTOL, "The concurrent precleaning phase of the concurrent mark sweep GC.")),
    CMS_ABORTABLE_PRECLEANING("CMS concurrent abortable precleaning phase", I18n._tss(I18n.TextType.XMSG, "GC event", "CMS concurrent abortable precleaning phase"), I18n._ts(I18n.TextType.XTOL, "The concurrent abortable precleaning phase of the concurrent mark sweep GC.")),
    CMS_FINAL_MARKING("CMS (stop-the-world) final marking phase", I18n._tss(I18n.TextType.XMSG, "GC event", "CMS (stop-the-world) final marking phase"), I18n._ts(I18n.TextType.XTOL, "The (stop-the-world) final marking phase of the concurrent mark sweep GC.")),
    CMS_SWEEPING("CMS (potentially concurrent) sweeping phase", I18n._tss(I18n.TextType.XMSG, "GC event", "CMS (potentially concurrent) sweeping phase"), I18n._ts(I18n.TextType.XTOL, "The (potentially concurrent) sweeping phase of the concurrent mark sweep GC.")),
    CMS_ABORTED("CMS unable to complete concurrently, stopping the world", I18n._tss(I18n.TextType.XMSG, "GC event", "CMS unable to complete concurrently, stopping the world"), I18n._ts(I18n.TextType.XTOL, "The concurrent mark sweep GC was unable to complete concurrently and has to stop the world.")),
    YOUNG_GEN_PROMOTION_FAILURE("Promotion failure during partial GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Promotion failure during partial GC"), I18n._ts(I18n.TextType.XTOL, "A promotion failure occurred during a partial GC, i.e. copying from one generation to the other failed due to missing space.")),
    G1_INCREMENTAL_GC("Partial garbage first GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Partial garbage first GC"), I18n._ts(I18n.TextType.XTOL, "A parallel scavenge (partial GC) in a garbage first GC.")),
    SKIPPED_G1_INCREMENTAL_GC("Skipped partial garbage first GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Skipped partial garbage first GC"), I18n._ts(I18n.TextType.XTOL, "A skipped parallel scavenge (partial GC) in a garbage first GC.")),
    G1_MARK_SWEEP_GC("Garbage first mark sweep (full GC)", I18n._tss(I18n.TextType.XMSG, "GC event", "Garbage first mark sweep (full GC)"), I18n._ts(I18n.TextType.XTOL, "A serial mark sweep (full GC) in a garbage first GC.")),
    SKIPPED_G1_MARK_SWEEP_GC("Skipped garbage first mark sweep (full GC)", I18n._tss(I18n.TextType.XMSG, "GC event", "Skipped garbage first mark sweep (full GC)"), I18n._ts(I18n.TextType.XTOL, "A skipped serial mark sweep (full GC) in a garbage first GC.")),
    G1_INITIAL_MARKING("G1 (stop-the-world) initial marking phase", I18n._tss(I18n.TextType.XMSG, "GC event", "G1 (stop-the-world) initial marking phase"), I18n._ts(I18n.TextType.XTOL, "The (stop-the-world) initial marking phase of the garbage first concurrent marking GC.")),
    G1_MARKING("G1 concurrent marking phase", I18n._tss(I18n.TextType.XMSG, "GC event", "G1 concurrent marking phase"), I18n._ts(I18n.TextType.XTOL, "The concurrent marking phase of the garbage first concurrent marking GC.")),
    G1_FINAL_MARKING("G1 (stop-the-world) final marking phase", I18n._tss(I18n.TextType.XMSG, "GC event", "G1 (stop-the-world) final marking phase"), I18n._ts(I18n.TextType.XTOL, "The (stop-the-world) final marking phase of the garbage first concurrent marking GC.")),
    G1_COUNTING("G1 concurrent counting phase", I18n._tss(I18n.TextType.XMSG, "GC event", "G1 concurrent counting phase"), I18n._ts(I18n.TextType.XTOL, "The concurrent counting phase of the garbage first concurrent marking GC.")),
    G1_CLEANUP("G1 (stop-the-world) cleanup phase", I18n._tss(I18n.TextType.XMSG, "GC event", "G1 (stop-the-world) cleanup phase"), I18n._ts(I18n.TextType.XTOL, "The (stop-the-world) cleanup phase of the garbage first concurrent marking GC.")),
    G1_CONCURRENT_CLEANUP("G1 concurrent cleanup phase", I18n._tss(I18n.TextType.XMSG, "GC event", "G1 concurrent cleanup phase"), I18n._ts(I18n.TextType.XTOL, "The concurrent cleanup phase of the garbage first concurrent marking GC.")),
    G1_BITMAP_CLEARING("G1 concurrent bitmap clearing phase", I18n._tss(I18n.TextType.XMSG, "GC event", "G1 concurrent bitmap clearing phase"), I18n._ts(I18n.TextType.XTOL, "The concurrent bitmap clearing phase of the garbage first concurrent marking GC.")),
    G1_MARKING_ABORTED("G1 unable to complete concurrently", I18n._tss(I18n.TextType.XMSG, "GC event", "G1 unable to complete concurrently"), I18n._ts(I18n.TextType.XTOL, "The garbage first concurrent marking GC was unable to complete concurrently.")),
    G1_ROOT_SCANNING("G1 concurrent root scanning phase", I18n._tss(I18n.TextType.XMSG, "GC event", "G1 concurrent root scanning phase"), I18n._ts(I18n.TextType.XTOL, "The concurrent root scanning phase of the garbage first concurrent marking GC.")),
    PARTIAL_REF_HANDLING("Partial heap reference handling", I18n._tss(I18n.TextType.XMSG, "GC event", "Partial heap reference handling"), I18n._ts(I18n.TextType.XTOL, "A reference processing event of a part of a heap that is not contained to one generation.")),
    CLASSUNLOADING_PHASE1("Classunloading phase 1 (unload from SystemDictionary)", I18n._tss(I18n.TextType.XMSG, "GC event", "Classunloading phase 1 (unload from SystemDictionary)"), I18n._ts(I18n.TextType.XTOL, "The classunloading phase 1 unloads the classes of unreachable classloaders from the system dictionary")),
    CLASSUNLOADING_PHASE2("Classunloading phase 2 (purge meta space)", I18n._tss(I18n.TextType.XMSG, "GC event", "Classunloading phase 2 (purge meta space)"), I18n._ts(I18n.TextType.XTOL, "The classunloading phase 2 reclaimes the memory in meta space and class space used by classes loaded by unreachable classloaders")),
    G1_PARALLEL_FULL_GC("Garbage first parallel full GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Garbage first parallel full GC"), I18n._ts(I18n.TextType.XTOL, "A parallel compact full GC in a garbage first GC.")),
    SKIPPED_G1_PARALLEL_FULL_GC("Skipped garbage first parallel full GC", I18n._tss(I18n.TextType.XMSG, "GC event", "Skipped garbage first parallel full GC"), I18n._ts(I18n.TextType.XTOL, "A skipped parallel compact full GC in a garbage first GC.")),
    G1_EMPTY_REGIONS_RECLAIM("G1 (stop-the-world) empty regions reclaim", I18n._tss(I18n.TextType.XMSG, "GC event", "G1 (stop-the-world) empty regions reclaim"), I18n._ts(I18n.TextType.XTOL, "The (stop-the-world) reclamation of empty regions of the garbage first concurrent marking GC."));

    private final String description;
    private final String displayShort;
    private final String displayLong;

    private GcEventType(String description, String displayShort, String displayLong) {
        this.description = description;
        this.displayShort = displayShort;
        this.displayLong = displayLong;
    }

    public String getDescription() {
        return this.description;
    }

    public String getShortDescrDisplay() {
        return this.displayShort;
    }

    public String getLongDescrDisplay() {
        return this.displayLong;
    }
}

