/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.memory.event;

import com.sap.jvm.profiling.i18n.I18n;

public enum GcG1CollectionSet {
    YOUNG("The collection set at this evacuation pause consists of all the young regions but no old region", I18n._tss(I18n.TextType.XMSG, "Regions in the collection set of a G1 evacuation pause", "young"), I18n._ts(I18n.TextType.XTOL, "The collection set at this evacuation pause consists of all the young regions but no old region")),
    MIXED("The collection set at this evacuation pause consists of all the young and some of the old regions", I18n._tss(I18n.TextType.XMSG, "Regions in the collection set of a G1 evacuation pause", "mixed"), I18n._ts(I18n.TextType.XTOL, "The collection set at this evacuation pause consists of all the young and some of the old regions")),
    ALL_FULL_GC("A full GC collects all regions", I18n._tss(I18n.TextType.XMSG, "Regions in the collection set of a G1 evacuation pause", "all"), I18n._ts(I18n.TextType.XTOL, "A full GC collects all regions")),
    ALL_CONC_MARK("G1 concurrent marking marks all live objects, but only regions without any live object are reclaimed", I18n._tss(I18n.TextType.XMSG, "Regions in the collection set of a G1 evacuation pause", "all"), I18n._ts(I18n.TextType.XTOL, "G1 concurrent marking marks all live objects, but only regions without any live object are reclaimed")),
    NONE("No collection set in this GC, e.g. because it was skipped", I18n._tss(I18n.TextType.XMSG, "Regions in the collection set of a G1 evacuation pause", "none"), I18n._ts(I18n.TextType.XTOL, "No collection set in this GC, e.g. because it was skipped")),
    UNKNOWN("No information about the collection set was found", I18n._tss(I18n.TextType.XMSG, "Regions in the collection set of a G1 evacuation pause", "unknown"), I18n._ts(I18n.TextType.XTOL, "No information about the collection set was found")),
    NOT_APPLICABLE("Only applicable to G1 GC", I18n._tss(I18n.TextType.XMSG, "Regions in the collection set of a G1 evacuation pause", "n/a"), I18n._ts(I18n.TextType.XTOL, "Only applicable to G1 GC"));

    private static GcG1CollectionSet[] elements;
    private final String displayShort;
    private final String displayLong;
    private final String description;

    private GcG1CollectionSet(String description, String displayShort, String displayLong) {
        this.displayShort = displayShort;
        this.displayLong = displayLong;
        this.description = description;
    }

    public String getShortDescription() {
        return this.displayShort;
    }

    public String getLongDescription() {
        return this.displayLong;
    }

    public String getDescription() {
        return this.description;
    }

    public static GcG1CollectionSet get(int ordinal) {
        return elements[ordinal];
    }

    static {
        elements = GcG1CollectionSet.values();
    }
}

