/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.memory.event;

import com.sap.jvm.profiling.i18n.I18n;

public enum GcG1YoungListTargetSelReason {
    NO_CHANGE("Young generation target length has not been recalculated", I18n._tss(I18n.TextType.XMSG, "Young list target length selection reason", "target length not recalculated"), I18n._ts(I18n.TextType.XTOL, "Young generation target length has not been recalculated"), 0),
    MIN_TOO_LARGE("Young generation target length changed to minimum but this is predicted not to meet constraints", I18n._tss(I18n.TextType.XMSG, "Young list target length selection reason", "minimum chosen, but it is too large"), I18n._ts(I18n.TextType.XTOL, "Young generation target length changed to minimum but this is predicted not to meet constraints"), 1),
    MIN_FITS_MAX_TOO_LARGE("Young generation target length changed to largest value between minimum and maximum that is predicted to meet constraints", I18n._tss(I18n.TextType.XMSG, "Young list target length selection reason", "value between minimum and maximum chosen"), I18n._ts(I18n.TextType.XTOL, "Young generation target length changed to largest value between minimum and maximum that is predicted to meet constraints"), 2),
    MAX_FITS("Young generation target length changed to maximum as this is predicted to meet constraints", I18n._tss(I18n.TextType.XMSG, "Young list target length selection reason", "maximum chosen"), I18n._ts(I18n.TextType.XTOL, "Young generation target length changed to maximum as this is predicted to meet constraints"), 3),
    IS_FIXED("Young generation target length set to desired fixed value", I18n._tss(I18n.TextType.XMSG, "Young list target length selection reason", "desiredc fixed value chosen"), I18n._ts(I18n.TextType.XTOL, "Young generation target length set to desired fixed value"), 4),
    DESIRED_MAX("Young generation target length set to desired maximum (less than calculated value)", I18n._tss(I18n.TextType.XMSG, "Young list target length selection reason", "desired maximum chosen"), I18n._ts(I18n.TextType.XTOL, "Young generation target length set to desired maximum (less than calculated value)"), 5),
    DESIRED_MIN("Young generation target length set to desired minimum (greater than calculated value)", I18n._tss(I18n.TextType.XMSG, "Young list target length selection reason", "desired minimum chosen"), I18n._ts(I18n.TextType.XTOL, "Young generation target length set to desired minimum (greater than calculated value)"), 6);

    private final String displayShort;
    private final String displayLong;
    private final String description;
    private final int value;

    private GcG1YoungListTargetSelReason(String description, String displayShort, String displayLong, int value) {
        this.displayShort = displayShort;
        this.displayLong = displayLong;
        this.description = description;
        this.value = value;
    }

    public String getShortDescription() {
        return this.displayShort;
    }

    public String getLongDescription() {
        return this.displayLong;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }

    public static int get(GcG1YoungListTargetSelReason reason) {
        switch (reason) {
            case NO_CHANGE: {
                return 0;
            }
            case MIN_TOO_LARGE: {
                return 1;
            }
            case MIN_FITS_MAX_TOO_LARGE: {
                return 2;
            }
            case MAX_FITS: {
                return 3;
            }
            case IS_FIXED: {
                return 4;
            }
            case DESIRED_MAX: {
                return 5;
            }
            case DESIRED_MIN: {
                return 6;
            }
        }
        throw new IllegalArgumentException("Unknown reason " + (Object)((Object)reason));
    }

    public static GcG1YoungListTargetSelReason get(int value) {
        switch (value) {
            case 0: {
                return NO_CHANGE;
            }
            case 1: {
                return MIN_TOO_LARGE;
            }
            case 2: {
                return MIN_FITS_MAX_TOO_LARGE;
            }
            case 3: {
                return MAX_FITS;
            }
            case 4: {
                return IS_FIXED;
            }
            case 5: {
                return DESIRED_MAX;
            }
            case 6: {
                return DESIRED_MIN;
            }
        }
        throw new IllegalArgumentException("Unknown reason " + value);
    }
}

