/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.memory.event;

import com.sap.jvm.profiling.i18n.I18n;

public enum GcSkippedReason {
    TIME_LIMIT("Too much time has been spent in GC", I18n._tss(I18n.TextType.XMSG, "GC skipped reason", "GC time too high"), I18n._ts(I18n.TextType.XTOL, "Too much time has been spent in GC"), 0),
    TO_SPACE_NOT_EMPTY("The 'to' space (survivor space) is not empty", I18n._tss(I18n.TextType.XMSG, "GC skipped reason", "'to' space not empty"), I18n._ts(I18n.TextType.XTOL, "The 'to' space (survivor space) is not empty"), 1),
    SCAVENGE_WITH_OBJECTS_IN_TO_SPACE_DISABLED("The 'to' space (survivor space) is not empty and 'ScavengeWithObjectsInToSpace' is disabled", I18n._tss(I18n.TextType.XMSG, "GC skipped reason", "'ScavengeWithObjectsInToSpace' disabled"), I18n._ts(I18n.TextType.XTOL, "The 'to' space (survivor space) is not empty and 'ScavengeWithObjectsInToSpace' is disabled"), 2),
    PROMOTION_PROBABLY_FAILS("The promotion is expected to fail", I18n._tss(I18n.TextType.XMSG, "GC skipped reason", "Promotion probably fails"), I18n._ts(I18n.TextType.XTOL, "The promotion is expected to fail"), 3),
    PROMOTION_CAN_FAIL("The promotion is not guaranteed to succeed (young generation guarantee not satisfied)", I18n._tss(I18n.TextType.XMSG, "GC skipped reason", "Promotion can fail"), I18n._ts(I18n.TextType.XTOL, "The promotion is not guaranteed to succeed (young generation guarantee not satisfied)"), 4),
    GC_LOCKER_ACTIVE("The GC locker was active and caused the GC to be delayed", I18n._tss(I18n.TextType.XMSG, "GC skipped reason", "GC locker active"), I18n._ts(I18n.TextType.XTOL, "The GC locker was active and caused the GC to be delayed"), 5),
    UNNECESSARY_GC("GC was unnecessary (e.g. eden was rather empty) and therefore omitted", I18n._tss(I18n.TextType.XMSG, "GC skipped reason", "unnecessary GC"), I18n._ts(I18n.TextType.XTOL, "GC was unnecessary (e.g. eden was rather empty) and therefore omitted"), 6);

    private final String displayShort;
    private final String displayLong;
    private final String description;
    private final int value;

    private GcSkippedReason(String description, String displayShort, String displayLong, int value) {
        this.displayShort = displayShort;
        this.displayLong = displayLong;
        this.description = description;
        this.value = value;
    }

    public String getShortDescription() {
        return this.displayShort;
    }

    public String getLongDescription() {
        return this.displayLong;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        return this.value;
    }
}

