/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.memory.event;

public enum GcStatisticTraceLevel {
    SHORT(0),
    MEDIUM(1),
    FULL(2);

    private static final GcStatisticTraceLevel[] VALUES;
    private static GcStatisticTraceLevel currentLevel;
    private final int level;

    private GcStatisticTraceLevel(int level) {
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    public static GcStatisticTraceLevel getCurrentLevel() {
        return currentLevel;
    }

    public static void setCurrentLevel(GcStatisticTraceLevel newLevel) {
        if (newLevel == null) {
            throw new NullPointerException();
        }
        currentLevel = newLevel;
    }

    public static GcStatisticTraceLevel get(int level) {
        int nearestLevel = Math.max(GcStatisticTraceLevel.VALUES[0].level, level);
        nearestLevel = Math.min(GcStatisticTraceLevel.VALUES[GcStatisticTraceLevel.VALUES.length - 1].level, nearestLevel);
        return VALUES[nearestLevel];
    }

    static {
        VALUES = new GcStatisticTraceLevel[]{SHORT, MEDIUM, FULL};
        currentLevel = FULL;
    }
}

