/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.memory.event;

import com.sap.jvm.profiling.i18n.I18n;

public enum GcType {
    UNSUPPORTED("unsupported GC", I18n._ss("GC type", "unsupported GC"), new String[0]),
    PARALLEL_GC("-XX:+UseParallelGC", I18n._ss("GC type", "Parallel GC"), "-XX:+UseParallelGC"),
    PARALLEL_OLD_GC("-XX:+UseParallelGC with -XX:+UseParallelOldGC", I18n._ss("GC type", "Parallel Old GC"), "-XX:+UseParallelGC", "-XX:+UseParallelOldGC"),
    SERIAL_GC("-XX:+UseSerialGC", I18n._ss("GC type", "Serial GC"), "-XX:+UseSerialGC"),
    PARALLEL_NEW_GC("-XX:+UseParNewGC", I18n._ss("GC type", "Parallel New GC"), "-XX:+UseParNewGC"),
    CONC_MARK_SWEEP_GC("-XX:+UseConcMarkSweepGC", I18n._ss("GC type", "Concurrent Mark-Sweep GC"), "-XX:+UseConcMarkSweepGC"),
    GARBAGE_FIRST_GC("-XX:+UseG1GC", I18n._ss("GC type", "Garbage First GC"), "-XX:+UseG1GC");

    private final String description;
    private String displayName;
    private String parametersText;

    private GcType(String description, String displayName, String ... parameters) {
        this.description = description;
        this.displayName = displayName;
        this.parametersText = GcType.getParametersText(parameters, displayName);
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getParametersText() {
        return this.parametersText;
    }

    private static String getParametersText(String[] params, String name) {
        if (params == null || params.length == 0) {
            return "";
        }
        if (params.length == 1) {
            return I18n._ss("GC type", "The {0} is enabled using the parameter {1}", name, params[0]);
        }
        if (params.length == 2) {
            return I18n._ss("GC type", "The {0} is enabled using the parameters {1} together with {2}", name, params[0], params[1]);
        }
        StringBuilder paramString = new StringBuilder();
        for (String param : params) {
            paramString.append(param).append(" ");
        }
        paramString.setLength(paramString.length() - 1);
        return I18n._ss("GC type", "The {0} is enabled using the parameters {1}", name, paramString.toString());
    }

    public String toString() {
        return this.name().replace('_', ' ');
    }
}

