/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.command;

import com.sap.jvm.profiling.method.response.MethodParameterIncludeType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public final class RequestedMethodParameter {
    private final String name;
    private final String description;
    private final String method;
    private final int index;
    private final MethodParameterIncludeType includeType;
    private final ArrayList<String> modifiers;

    public RequestedMethodParameter(String name, String description, String method, int index, MethodParameterIncludeType includeType, List<String> modifiers) {
        assert (index >= -2);
        this.name = name;
        this.description = description;
        this.method = method;
        this.index = index;
        this.includeType = includeType;
        this.modifiers = new ArrayList<String>(modifiers);
    }

    public RequestedMethodParameter(String name, String description, String method, int index, MethodParameterIncludeType includeType, String ... modifiers) {
        assert (index >= -2);
        this.name = name;
        this.description = description;
        this.method = method;
        this.index = index;
        this.includeType = includeType;
        this.modifiers = new ArrayList<String>(Arrays.asList(modifiers));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getMethod() {
        return this.method;
    }

    public int getIndex() {
        return this.index;
    }

    public MethodParameterIncludeType getIncludeType() {
        return this.includeType;
    }

    public List<String> getModifiers() {
        return new ArrayList<String>(this.modifiers);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RequestedMethodParameter)) {
            return false;
        }
        RequestedMethodParameter compare = (RequestedMethodParameter)obj;
        return compare.name.equals(this.name) && compare.method.equals(this.method) && compare.index == this.index && compare.includeType == this.includeType && compare.modifiers.equals(this.modifiers);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Requested Method Parameter[").append("name=").append(this.getName()).append(",description=").append(this.getDescription()).append(",method=").append(this.getMethod()).append(",index=").append(this.getIndex()).append(",includeType=").append((Object)this.getIncludeType()).append(",modifiers=(");
        Iterator<String> it = this.modifiers.iterator();
        while (it.hasNext()) {
            builder.append(it.next());
            if (!it.hasNext()) continue;
            builder.append(",");
        }
        builder.append(")]");
        return builder.toString();
    }
}

