/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.event;

import com.sap.jvm.profiling.impl.method.response.MethodParameterSpecImpl;
import com.sap.jvm.profiling.method.event.MethodParameterDefinitions;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class MethodParametersDefinition {
    private final MethodParameterSpecImpl[] specs;
    private final int definitionIndex;
    private final int[] indices;

    public static MethodParametersDefinition read(ResourceReader reader, MethodParameterDefinitions parameterDefinitions) throws IOException {
        int maxNrOfSpecs = parameterDefinitions.getNrOfSpecs();
        int definitionIndex = reader.readInt32();
        int nrOfSpecs = reader.readInt32();
        MethodParameterSpecImpl[] specs = new MethodParameterSpecImpl[nrOfSpecs];
        for (int i = 0; i < nrOfSpecs; ++i) {
            int offset = reader.readInt32();
            specs[i] = parameterDefinitions.getSpec(offset);
        }
        return new MethodParametersDefinition(maxNrOfSpecs, definitionIndex, specs);
    }

    public MethodParametersDefinition(int maxNumberOfSpecs, int definitionIndex, MethodParameterSpecImpl[] specs) {
        int i;
        this.specs = (MethodParameterSpecImpl[])specs.clone();
        this.definitionIndex = definitionIndex;
        this.indices = new int[maxNumberOfSpecs];
        for (i = 0; i < maxNumberOfSpecs; ++i) {
            this.indices[i] = -1;
        }
        i = 0;
        while (i < specs.length) {
            int index = specs[i].getOffset();
            assert (this.indices[index] == -1);
            this.indices[index] = i++;
        }
    }

    public int getNrOfSpecs() {
        return this.specs.length;
    }

    public MethodParameterSpecImpl getSpec(int index) {
        return this.specs[index];
    }

    public int getIndex(MethodParameterSpecImpl spec) {
        return this.indices[spec.getOffset()];
    }

    public int getDefinitionIndex() {
        return this.definitionIndex;
    }

    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)413);
        writer.writeInt32(this.definitionIndex);
        writer.writeInt32(this.specs.length);
        for (int i = 0; i < this.specs.length; ++i) {
            writer.writeInt32(this.specs[i].getOffset());
        }
        writer.finalizePacket();
    }
}

