/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;

public final class BooleanParameter
extends Parameter {
    private final boolean value;

    public BooleanParameter(boolean value) {
        this.value = value;
    }

    public BooleanParameter(ResourceReader reader) throws IOException {
        this.value = reader.readBoolean();
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print(this.value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof BooleanParameter) {
            return ((BooleanParameter)obj).getValue() == this.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(ParameterType.BOOLEAN.getTag());
        writer.writeBoolean(this.value);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.BOOLEAN;
    }

    @Override
    public boolean isErrorType() {
        return false;
    }
}

