/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.method.parameters.IntegerTypeParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;

public final class ByteParameter
extends Parameter
implements IntegerTypeParameter {
    private final byte value;

    public ByteParameter(byte value) {
        this.value = value;
    }

    public ByteParameter(ResourceReader reader) throws IOException {
        this.value = reader.readInt8();
    }

    public byte getValue() {
        return this.value;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print(this.value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ByteParameter) {
            return ((ByteParameter)obj).getValue() == this.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Byte.toString(this.value);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(ParameterType.BYTE.getTag());
        writer.writeInt8(this.value);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.BYTE;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public boolean isErrorType() {
        return false;
    }
}

