/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.method.parameters.IntegerTypeParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;

public final class CharParameter
extends Parameter
implements IntegerTypeParameter {
    private final char value;

    public CharParameter(char value) {
        this.value = value;
    }

    public CharParameter(ResourceReader reader) throws IOException {
        this.value = (char)reader.readInt16();
    }

    public char getValue() {
        return this.value;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print(this.value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof CharParameter) {
            return ((CharParameter)obj).getValue() == this.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Character.toString(this.value);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(ParameterType.CHAR.getTag());
        writer.writeInt16((short)this.value);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.CHAR;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public boolean isErrorType() {
        return false;
    }
}

