/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;

public final class ClassParameter
extends Parameter {
    private final ClassObject clazz;

    public ClassParameter(ClassObject clazz) {
        this.clazz = clazz;
    }

    public ClassParameter(ResourceReader reader) throws IOException {
        this.clazz = reader.readClassObject();
    }

    @Override
    public void print(PrintStream stream) {
        stream.print(this.clazz.getFullName());
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(ParameterType.CLASS.getTag());
        writer.writeInt32(this.clazz.getIndex());
    }

    public ClassObject getValue() {
        return this.clazz;
    }

    @Override
    public ParameterType getType() {
        return ParameterType.CLASS;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassParameter) {
            return this.clazz == ((ClassParameter)obj).clazz;
        }
        return false;
    }

    public int hashCode() {
        return this.clazz.hashCode();
    }

    public String toString() {
        return this.clazz.getFullName();
    }

    @Override
    public boolean isErrorType() {
        return false;
    }
}

