/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.method.parameters.FloatTypeParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;

public final class DoubleParameter
extends Parameter
implements FloatTypeParameter {
    private final double value;

    public DoubleParameter(double value) {
        this.value = value;
    }

    public DoubleParameter(ResourceReader reader) throws IOException {
        this.value = reader.readDouble();
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print(this.value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof DoubleParameter) {
            return ((DoubleParameter)obj).getValue() == this.value;
        }
        return false;
    }

    public int hashCode() {
        long tmp = Double.doubleToLongBits(this.value);
        return (int)(tmp ^ tmp >>> 32);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(ParameterType.DOUBLE.getTag());
        writer.writeDouble(this.value);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.DOUBLE;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public boolean isErrorType() {
        return false;
    }
}

