/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.method.parameters.FloatTypeParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;

public final class FloatParameter
extends Parameter
implements FloatTypeParameter {
    private final float value;

    public FloatParameter(float value) {
        this.value = value;
    }

    public FloatParameter(ResourceReader reader) throws IOException {
        this.value = reader.readFloat();
    }

    public float getValue() {
        return this.value;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print(this.value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FloatParameter) {
            return ((FloatParameter)obj).getValue() == this.value;
        }
        return false;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.value);
    }

    public String toString() {
        return Float.toString(this.value);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(ParameterType.FLOAT.getTag());
        writer.writeFloat(this.value);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.FLOAT;
    }

    @Override
    public double asDouble() {
        return this.value;
    }

    @Override
    public boolean isErrorType() {
        return false;
    }
}

