/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.method.parameters.IntegerTypeParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;

public final class IntParameter
extends Parameter
implements IntegerTypeParameter {
    private final int value;

    public IntParameter(int value) {
        this.value = value;
    }

    public IntParameter(ResourceReader reader) throws IOException {
        this.value = reader.readInt32();
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print(this.value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof IntParameter) {
            return ((IntParameter)obj).value == this.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(ParameterType.INT.getTag());
        writer.writeInt32(this.value);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.INT;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public boolean isErrorType() {
        return false;
    }
}

