/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.method.parameters.IntegerTypeParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;

public final class LongParameter
extends Parameter
implements IntegerTypeParameter {
    private final long value;

    public LongParameter(long value) {
        this.value = value;
    }

    public LongParameter(ResourceReader reader) throws IOException {
        this.value = reader.readInt64();
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print(this.value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LongParameter) {
            return ((LongParameter)obj).getValue() == this.value;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public String toString() {
        return Long.toString(this.value);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(ParameterType.LONG.getTag());
        writer.writeInt64(this.value);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.LONG;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public boolean isErrorType() {
        return false;
    }
}

