/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;

public class MethodParameter
extends Parameter {
    private final MethodObject method;
    private final ClassObject receiverClass;

    public MethodParameter(MethodObject method, ClassObject receiverClass) {
        this.method = method;
        this.receiverClass = receiverClass;
    }

    public MethodParameter(ResourceReader reader) throws IOException {
        this.method = reader.readMethodObject();
        this.receiverClass = reader.readClassObject();
    }

    @Override
    public void print(PrintStream stream) {
        stream.print(this);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(ParameterType.METHOD.getTag());
        writer.writeMethodObject(this.method);
        writer.writeClassObject(this.receiverClass);
    }

    public MethodObject getMethod() {
        return this.method;
    }

    public ClassObject getReceiverClass() {
        return this.receiverClass;
    }

    @Override
    public ParameterType getType() {
        return ParameterType.METHOD;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodParameter) {
            MethodParameter other = (MethodParameter)obj;
            return this.method.equals(other.method) && this.receiverClass.equals(other.receiverClass);
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode() ^ this.receiverClass.hashCode();
    }

    public String toString() {
        return this.receiverClass.getFullName() + "." + this.method.getName() + "(" + this.method.getSignature() + ")" + this.method.getReturnType();
    }

    @Override
    public boolean isErrorType() {
        return false;
    }
}

