/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.method.parameters.BooleanParameter;
import com.sap.jvm.profiling.method.parameters.ByteParameter;
import com.sap.jvm.profiling.method.parameters.CharParameter;
import com.sap.jvm.profiling.method.parameters.ClassCastExceptionParameter;
import com.sap.jvm.profiling.method.parameters.ClassParameter;
import com.sap.jvm.profiling.method.parameters.DoubleParameter;
import com.sap.jvm.profiling.method.parameters.EnableFailedParameter;
import com.sap.jvm.profiling.method.parameters.ExceptionInCallParameter;
import com.sap.jvm.profiling.method.parameters.FloatParameter;
import com.sap.jvm.profiling.method.parameters.IndexOutOfBoundsParameter;
import com.sap.jvm.profiling.method.parameters.IntParameter;
import com.sap.jvm.profiling.method.parameters.LongParameter;
import com.sap.jvm.profiling.method.parameters.MethodParameter;
import com.sap.jvm.profiling.method.parameters.NullInCallParameter;
import com.sap.jvm.profiling.method.parameters.NullParameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.method.parameters.ShortParameter;
import com.sap.jvm.profiling.method.parameters.StringParameter;
import com.sap.jvm.profiling.method.parameters.UnknownParameter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;

public abstract class Parameter {
    public abstract void print(PrintStream var1);

    public abstract void write(ResourceWriter var1) throws IOException;

    public abstract ParameterType getType();

    public abstract boolean isErrorType();

    public static Parameter read(ResourceReader reader, int tag) throws IOException {
        Parameter parameter;
        if (tag == ParameterType.BOOLEAN.getTag()) {
            parameter = new BooleanParameter(reader);
        } else if (tag == ParameterType.BYTE.getTag()) {
            parameter = new ByteParameter(reader);
        } else if (tag == ParameterType.SHORT.getTag()) {
            parameter = new ShortParameter(reader);
        } else if (tag == ParameterType.CHAR.getTag()) {
            parameter = new CharParameter(reader);
        } else if (tag == ParameterType.INT.getTag()) {
            parameter = new IntParameter(reader);
        } else if (tag == ParameterType.LONG.getTag()) {
            parameter = new LongParameter(reader);
        } else if (tag == ParameterType.FLOAT.getTag()) {
            parameter = new FloatParameter(reader);
        } else if (tag == ParameterType.DOUBLE.getTag()) {
            parameter = new DoubleParameter(reader);
        } else if (tag == ParameterType.STRING.getTag()) {
            parameter = new StringParameter(reader);
        } else if (tag == ParameterType.CLASS.getTag()) {
            parameter = new ClassParameter(reader);
        } else if (tag == ParameterType.NULL.getTag()) {
            parameter = new NullParameter();
        } else if (tag == ParameterType.NULL_INVOCATION_DURING_CALL.getTag()) {
            parameter = new NullInCallParameter();
        } else if (tag == ParameterType.INDEX_OUT_OF_BOUNDS.getTag()) {
            parameter = new IndexOutOfBoundsParameter();
        } else if (tag == ParameterType.CLASS_CAST_EXCEPTION.getTag()) {
            parameter = new ClassCastExceptionParameter();
        } else if (tag == ParameterType.UNKNOWN.getTag()) {
            parameter = new UnknownParameter();
        } else if (tag == ParameterType.ENABLE_FAILED.getTag()) {
            parameter = new EnableFailedParameter();
        } else if (tag == ParameterType.METHOD.getTag()) {
            parameter = new MethodParameter(reader);
        } else {
            assert (tag == ParameterType.EXCEPTION_DURING_CALL.getTag());
            parameter = new ExceptionInCallParameter();
        }
        return parameter;
    }

    public static Parameter read(ResourceReader reader) throws IOException {
        byte tag = reader.readInt8();
        return Parameter.read(reader, tag);
    }
}

