/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.method.parameters.IntegerTypeParameter;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;

public final class ShortParameter
extends Parameter
implements IntegerTypeParameter {
    private final short value;

    public ShortParameter(short value) {
        this.value = value;
    }

    public ShortParameter(ResourceReader reader) throws IOException {
        this.value = reader.readInt16();
    }

    public short getValue() {
        return this.value;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print(this.value);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ShortParameter) {
            return ((ShortParameter)obj).getValue() == this.value;
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return Short.toString(this.value);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(ParameterType.SHORT.getTag());
        writer.writeInt16(this.value);
    }

    @Override
    public ParameterType getType() {
        return ParameterType.SHORT;
    }

    @Override
    public long asLong() {
        return this.value;
    }

    @Override
    public boolean isErrorType() {
        return false;
    }
}

