/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.method.parameters;

import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.method.parameters.ParameterType;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.util.misc.UTF8Util;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;

public final class StringParameter
extends Parameter {
    private final byte[] value;

    public StringParameter(byte[] value) {
        this.value = value;
    }

    public StringParameter(ResourceReader reader) throws IOException {
        this.value = reader.readUTF().getBytes();
    }

    public byte[] getUTF() {
        return this.value;
    }

    public String getValue() {
        return UTF8Creator.create(this.value).toString();
    }

    @Override
    public void print(PrintStream stream) {
        stream.print(this.getValue());
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof StringParameter) {
            StringParameter tmp = (StringParameter)obj;
            return Arrays.equals(this.value, tmp.value);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    public String toString() {
        return UTF8Util.asString(this.value);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt8(ParameterType.STRING.getTag());
        writer.writeUTF(writer.getSession().getStringManager().create(this.value));
    }

    @Override
    public ParameterType getType() {
        return ParameterType.STRING;
    }

    @Override
    public boolean isErrorType() {
        return false;
    }
}

