/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.net.event;

import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.impl.core.type.IpAddressV4Impl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV6Impl;
import com.sap.jvm.profiling.net.event.SocketBindEvent;
import com.sap.jvm.profiling.net.event.SocketOpenEvent;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public final class IpAddressUtil {
    public static IpAddress read(ResourceReader reader) throws IOException {
        if (reader.readBoolean()) {
            return IpAddressV4Impl.read(reader);
        }
        return IpAddressV6Impl.read(reader);
    }

    public static void write(ResourceWriter writer, IpAddress address) throws IOException {
        assert (address.isIPv4() || address.isIPv6());
        writer.writeBoolean(address.isIPv4());
        address.write(writer);
    }

    public static IpAddress getUnknownAddress(SocketOpenEvent event) {
        if (event.isIPv4()) {
            return IpAddressV4Impl.UNKNOWN;
        }
        assert (event.isIPv6());
        return IpAddressV6Impl.UNKNOWN;
    }

    public static IpAddress getUnknownAddress(SocketBindEvent event) {
        if (event.isIPv4()) {
            return IpAddressV4Impl.UNKNOWN;
        }
        assert (event.isIPv6());
        return IpAddressV6Impl.UNKNOWN;
    }

    public static IpAddress getDefaultUnknownAddress() {
        return IpAddressV4Impl.UNKNOWN;
    }

    public static boolean isUnknown(IpAddress address) {
        if (address.isIPv4()) {
            return IpAddressV4Impl.UNKNOWN.equals(address);
        }
        assert (address.isIPv6());
        return IpAddressV6Impl.UNKNOWN.equals(address);
    }

    public static int compare(IpAddress first, IpAddress second) {
        if (first == null) {
            return second == null ? 0 : -1;
        }
        if (second == null) {
            return 1;
        }
        if (first.getClass() != second.getClass()) {
            assert (first instanceof IpAddressV4Impl || first instanceof IpAddressV6Impl);
            assert (second instanceof IpAddressV4Impl || second instanceof IpAddressV6Impl);
            return first instanceof IpAddressV4Impl ? -1 : 1;
        }
        if (first instanceof IpAddressV4Impl) {
            return ((IpAddressV4Impl)first).compareTo((IpAddressV4Impl)second);
        }
        assert (first instanceof IpAddressV6Impl);
        return ((IpAddressV6Impl)first).compareTo((IpAddressV6Impl)second);
    }
}

