/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.resource;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.resource.AbstractResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.persistence.ContinuedPacketReader;
import java.io.EOFException;
import java.io.IOException;

public abstract class AbstractPacketResourceReader
extends AbstractResourceReader
implements PacketResourceReader {
    protected long nrOfPacketsToRead;
    protected long nrOfReadPackets;
    protected ContinuedPacketReader packetReader;
    private ContinuedPacketReader.BinaryPacket packet;
    private int type;

    protected AbstractPacketResourceReader(ProfilingSession session) {
        this(session, Long.MAX_VALUE);
    }

    protected AbstractPacketResourceReader(ProfilingSession session, long nrOfPacketsToRead) {
        super(session);
        this.nrOfPacketsToRead = nrOfPacketsToRead;
    }

    protected void setPacketReader(ContinuedPacketReader packetReader) {
        assert (this.packetReader == null);
        this.packetReader = packetReader;
    }

    @Override
    public int nextPacketType() throws IOException {
        if (this.nrOfReadPackets >= this.nrOfPacketsToRead) {
            return -1;
        }
        return this.packetReader.readPacketType();
    }

    @Override
    public boolean nextPacket() throws IOException {
        if (this.nrOfReadPackets >= this.nrOfPacketsToRead) {
            return false;
        }
        try {
            ContinuedPacketReader.BinaryPacket nextPacket = this.packetReader.readBinaryPacket();
            if (nextPacket == null) {
                return false;
            }
            ++this.nrOfReadPackets;
            this.setNextPacketData(nextPacket);
            return true;
        }
        catch (EOFException e) {
            if (this.nrOfPacketsToRead != Long.MAX_VALUE) {
                Trace.error((Throwable)e, "Unexpected EOF");
            }
            return false;
        }
    }

    @Override
    public long getNrOfPacketsToRead() {
        return this.nrOfPacketsToRead;
    }

    @Override
    public long getNrOfReadPackets() {
        return this.nrOfReadPackets;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    protected void ensureBytes(int nrOfBytes) throws EOFException {
        assert (nrOfBytes <= 8);
        if (this.packet == null) {
            return;
        }
        this.index -= this.size - 8;
        this.data = this.packet.nextData();
        this.size = this.packet.getSize();
        this.packet = this.packet.isContinued() ? this.packet : null;
    }

    private void setNextPacketData(ContinuedPacketReader.BinaryPacket binaryPacket) {
        this.type = binaryPacket.getType();
        this.size = binaryPacket.getSize();
        this.data = binaryPacket.getData();
        this.packet = binaryPacket.isContinued() ? binaryPacket : null;
        this.index = 8;
    }

    @Override
    public void close() {
        this.packetReader.close();
    }
}

