/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.resource;

import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceHandler;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractResourceHandlerFactory {
    private final ArrayList<ResourceHandler> handlers = new ArrayList();
    private final ArrayList<ResourceNameElement> elements = new ArrayList();

    public ResourceHandler get(ResourceName name) {
        for (ResourceHandler handler : this.handlers) {
            if (!handler.canHandle(name)) continue;
            return handler;
        }
        return null;
    }

    public void addElements(List<ResourceNameElement> toAdd) {
        toAdd.addAll(this.elements);
    }

    protected final void add(AbstractResourceHandlerFactory otherFactory) {
        this.handlers.addAll(otherFactory.handlers);
        this.elements.addAll(otherFactory.elements);
    }

    protected final void add(ResourceNameElement element) {
        this.elements.add(element);
    }

    protected final void add(ResourceHandler handler) {
        this.handlers.add(handler);
    }

    protected final void add(ResourceHandler handler, ResourceNameElement element) {
        this.handlers.add(handler);
        this.elements.add(element);
    }

    protected final void add(ResourceNameElement element, Class<? extends Resource> resource) {
        this.handlers.add(this.getHandler(element, resource));
        this.elements.add(element);
    }

    protected abstract ResourceHandler getHandler(ResourceNameElement var1, Class<? extends Resource> var2);
}

