/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.resource;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.AbstractBasicResourceReader;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.EOFException;
import java.io.IOException;

public abstract class AbstractResourceReader
extends AbstractBasicResourceReader
implements ResourceReader {
    protected final ProfilingSession session;

    protected AbstractResourceReader(ProfilingSession session) {
        this.session = session;
    }

    @Override
    public ProfilingSession getSession() {
        return this.session;
    }

    @Override
    public UTF8String readInternedUTF() throws EOFException {
        return this.session.getStringManager().intern(this.readUTF());
    }

    @Override
    public UTF8String readUTF() throws EOFException {
        char utflen = this.readUint16();
        if (utflen == '\u0000') {
            return this.session.getStringManager().getEmptyString();
        }
        byte[] retValue = new byte[utflen];
        this.readBytes(retValue, 0, utflen);
        return this.session.getStringManager().create(retValue);
    }

    @Override
    public MethodLocation readMethodLocation() throws EOFException {
        return this.session.getMethodLocationManager().getLocation(this.readInt32());
    }

    @Override
    public PackageName readPackageName() throws IOException {
        return this.session.getPackageNameManager().getPackageName(this.readInternedUTF(), this.readBoolean());
    }

    @Override
    public ThreadFilter readThreadFilter() throws EOFException {
        ThreadFilter filter = new ThreadFilter();
        String userHeader = this.readString();
        if (userHeader == null || userHeader.equals("") || userHeader.equals("**")) {
            return filter;
        }
        assert (userHeader.equals("user="));
        int userPatternLength = this.readInt32();
        assert (userPatternLength >= 0);
        char[] userPatternChars = new char[userPatternLength];
        for (int i = 0; i < userPatternLength; ++i) {
            userPatternChars[i] = this.readUint16();
        }
        String userPattern = new String(userPatternChars);
        if (ThreadFilter.isFiltering(userPattern)) {
            filter.filterUser(userPattern);
        }
        return filter;
    }

    @Override
    public ThreadFilter readNewThreadFilter() throws EOFException {
        String filterString = this.readString();
        return new ThreadFilter(filterString);
    }
}

