/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.resource;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.resource.AbstractBasicResourceWriter;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.UTFDataFormatException;

public abstract class AbstractResourceWriter
extends AbstractBasicResourceWriter
implements ResourceWriter {
    private final ProfilingSession session;

    protected AbstractResourceWriter(ProfilingSession session) {
        this.session = session;
    }

    @Override
    public ProfilingSession getSession() {
        return this.session;
    }

    @Override
    public void writeUTF(UTF8String value) throws IOException {
        char len = (char)value.length();
        if (len != value.length()) {
            throw new UTFDataFormatException("UTF string too long: " + value.length() + " bytes");
        }
        this.writeUint16(len);
        this.writeBytes(value.getBytes(), 0, value.length());
    }

    @Override
    public void writeClassLoaderObject(ClassLoaderObject classLoaderObject) throws IOException {
        this.writeInt32(classLoaderObject == null ? -1 : classLoaderObject.getIndex());
    }

    @Override
    public void writeClassObject(ClassObject classObject) throws IOException {
        this.writeInt32(classObject == null ? -1 : classObject.getIndex());
    }

    @Override
    public void writeMethodObject(MethodObject methodObject) throws IOException {
        this.writeInt32(methodObject == null ? -1 : methodObject.getIndex());
    }

    @Override
    public void writeMethodLocation(MethodLocation location) throws IOException {
    }

    @Override
    public void writePackageName(PackageName name) throws IOException {
    }

    @Override
    public void writeThreadFilter(ThreadFilter threadFilter) throws IOException {
        String userPattern = threadFilter.getUserFilter();
        if (userPattern == null) {
            this.writeString("**");
            return;
        }
        this.writeString("user=");
        this.writeInt32(userPattern.length());
        for (int i = 0; i < userPattern.length(); ++i) {
            this.writeUint16(userPattern.charAt(i));
        }
    }

    @Override
    public void writeNewThreadFilter(ThreadFilter threadFilter) throws IOException {
        this.writeString(threadFilter.asString());
    }
}

