/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.resource;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.ClassLoaderManager;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.ClassObjectManager;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.MethodObjectManager;
import com.sap.jvm.profiling.resource.AbstractResourceReader;
import com.sap.jvm.profiling.resource.ResourceName;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamResourceReader
extends AbstractResourceReader {
    private final InputStream is;
    private final ClassObjectManager cm;
    private final ClassLoaderManager clm;
    private final MethodObjectManager mm;

    public InputStreamResourceReader(InputStream is, ProfilingSession session) {
        super(session);
        this.is = is;
        this.cm = session.getClassObjectManager();
        this.clm = session.getClassLoaderManager();
        this.mm = session.getMethodObjectManager();
        this.data = new byte[8];
    }

    @Override
    public long readClassLoaderId() throws EOFException {
        return this.readInt32();
    }

    @Override
    public ClassLoaderObject readClassLoaderObject() throws EOFException {
        return this.clm.getClassLoaderObject(this.readInt32());
    }

    @Override
    public long readClassObjectId() throws EOFException {
        return this.readInt32();
    }

    @Override
    public ClassObject readClassObject() throws EOFException {
        return this.cm.getClassObject(this.readInt32());
    }

    @Override
    public long readMethodObjectId() throws EOFException {
        return this.readInt32();
    }

    @Override
    public MethodObject readMethodObject() throws EOFException {
        return this.mm.getMethodObject(this.readInt32());
    }

    @Override
    public ResourceName readResourceName() throws IOException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public int readStackTraceIndex() throws EOFException {
        return this.readInt32();
    }

    @Override
    public long readUniqueFileId() throws EOFException {
        return this.readInt64();
    }

    @Override
    public long readUniqueSocketId() throws EOFException {
        return this.readInt64();
    }

    @Override
    public int getStackTraceIndexForObjectId(long objectId) throws EOFException {
        throw new RuntimeException("Not implemented");
    }

    @Override
    protected void ensureBytes(int nrOfBytes) throws EOFException {
        assert (nrOfBytes <= 8);
        try {
            int read;
            this.index = 0;
            this.size = 0;
            for (int left = nrOfBytes; left > 0; left -= read) {
                read = this.is.read(this.data, this.size, left);
                if (read <= 0) {
                    throw new EOFException();
                }
                this.size += read;
            }
        }
        catch (IOException e) {
            EOFException e2 = new EOFException();
            e2.initCause(e);
            throw e2;
        }
    }

    public void close() throws IOException {
        this.is.close();
    }
}

