/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.resource;

import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporterListener;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.tracing.Tracer;
import com.sap.jvm.util.threads.RunWaiter;
import com.sap.jvm.util.threads.ThreadRunner;
import java.lang.ref.WeakReference;
import java.util.ArrayList;

public final class ProgressReporter {
    private static final String PERCENT_TAG = "[<](percent|[%])[>]";
    private static final Tracer tracer = Trace.get(ProgressReporter.class);
    private static final int TRACE_THRESHOLD_IN_MS = 2000;
    private static final int WARN_THRESHOLD_IN_MS = 30000;
    private final boolean isChild;
    private boolean cancelled;
    private long actualWork;
    private long maximumWork;
    private volatile boolean informListeners;
    private String[] messageParts;
    private final ArrayList<ProgressReporterListener> listeners;
    private final ArrayList<ProgressReporter> children;
    private boolean finished;
    private final double initialInterval;
    private final double interval;
    private RunWaiter<Void> waiter;
    private Exception creationStackTrace;

    public ProgressReporter(String message, double initialInterval, double interval) {
        this.initialInterval = initialInterval;
        this.interval = interval;
        this.setMessage(message);
        this.isChild = false;
        this.informListeners = true;
        this.listeners = new ArrayList();
        this.children = new ArrayList();
        this.creationStackTrace = new Exception();
    }

    public ProgressReporter(String message) {
        this(message, 0.1, 0.2);
    }

    public ProgressReporter() {
        this((String)null);
    }

    private ProgressReporter(ProgressReporter parent) {
        this.setMessage(null);
        this.maximumWork = 1L;
        this.initialInterval = 0.0;
        this.interval = 0.0;
        this.isChild = true;
        this.listeners = new ArrayList();
        this.children = new ArrayList();
    }

    public void setMessage(String message) {
        assert (!this.finished);
        this.messageParts = message == null ? new String[0] : message.split(PERCENT_TAG);
    }

    public void addWork(String message, long workToAdd) {
        this.setMessage(message);
        this.addToMaximumWork(workToAdd);
    }

    public void setWork(String message, long workToSet) {
        this.setMessage(message);
        this.report(0L, workToSet);
    }

    public void cancel() {
        assert (!this.finished);
        this.cancelled = true;
        for (ProgressReporter child : this.children) {
            child.cancel();
        }
    }

    public void finish() {
        assert (!this.finished);
        this.finished = true;
        for (ProgressReporterListener listener : this.listeners) {
            listener.notifyFinished(this);
        }
        if (this.waiter != null) {
            this.waiter.interrupt();
            this.waiter.waitOnFinish();
        }
    }

    public String getActualMessage() {
        assert (!this.finished);
        if (this.messageParts.length == 0) {
            return null;
        }
        if (this.messageParts.length == 1) {
            return this.messageParts[0];
        }
        StringBuilder result = new StringBuilder(this.messageParts[0]);
        String percentage = this.maximumWork == 0L ? "0" : Integer.toString((int)(this.getActualWork() * 100L / this.getMaximumWork()));
        for (int i = 1; i < this.messageParts.length; ++i) {
            result.append(percentage);
            result.append(this.messageParts[i]);
        }
        return result.toString();
    }

    public boolean report(long newActualWork) {
        assert (!this.finished);
        if (this.cancelled) {
            return false;
        }
        if (this.isChild) {
            return true;
        }
        if (this.waiter == null) {
            this.waiter = ThreadRunner.run(new UpdateRunnable(this));
        }
        this.actualWork = newActualWork;
        if (this.informListeners) {
            this.informListeners = false;
            return this.informListeners();
        }
        return true;
    }

    public void reportWorkOrThrow(long workDone) throws OperationCanceledException {
        if (!this.report(this.actualWork + workDone)) {
            throw new OperationCanceledException();
        }
    }

    public boolean reportNext() {
        return this.report(this.actualWork + 1L);
    }

    public void reportNextOrThrow() throws OperationCanceledException {
        if (!this.reportNext()) {
            throw new OperationCanceledException();
        }
    }

    public boolean report(long newActualWork, long newMaximumWork) {
        assert (!this.finished);
        assert (newActualWork <= newMaximumWork);
        if (this.cancelled) {
            return false;
        }
        if (this.isChild) {
            return true;
        }
        if (this.waiter == null) {
            this.waiter = ThreadRunner.run(new UpdateRunnable(this));
        }
        this.actualWork = newActualWork;
        this.maximumWork = newMaximumWork;
        if (this.informListeners) {
            this.informListeners = false;
            return this.informListeners();
        }
        return true;
    }

    public void addToMaximumWork(long toAdd) {
        this.maximumWork += toAdd;
    }

    public synchronized ProgressReporter[] getChildren(int nrOfChildren) {
        ProgressReporter[] result = new ProgressReporter[nrOfChildren];
        for (int i = 0; i < nrOfChildren; ++i) {
            result[i] = new ProgressReporter(this);
            this.children.add(result[i]);
        }
        return result;
    }

    public synchronized ProgressReporter getChild() {
        return this.getChildren(1)[0];
    }

    public void addListener(ProgressReporterListener listener) {
        this.listeners.add(listener);
    }

    public boolean removeListener(ProgressReporterListener listener) {
        return this.listeners.remove(listener);
    }

    public long getActualWork() {
        return Math.min(this.actualWork, this.maximumWork);
    }

    public long getMaximumWork() {
        return this.maximumWork;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    private synchronized boolean informListeners() {
        for (ProgressReporterListener listener : this.listeners) {
            if (listener.report(this)) continue;
            this.cancelled = true;
            return false;
        }
        return true;
    }

    private synchronized void checkListeners() {
        for (ProgressReporterListener listener : this.listeners) {
            if (!listener.shouldCancel()) continue;
            this.cancelled = true;
        }
    }

    private static class UpdateRunnable
    implements Runnable {
        private final WeakReference<ProgressReporter> ref;
        private final int initialInterval;
        private final int interval;
        private int informListenersWasSet;
        private long lastResponseTime;
        private boolean haveTraced;
        private boolean haveWarned;

        public UpdateRunnable(ProgressReporter reporter) {
            this.ref = new WeakReference<ProgressReporter>(reporter);
            this.initialInterval = (int)(1000.0 * reporter.initialInterval);
            this.interval = (int)(1000.0 * reporter.interval);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.initialInterval);
            }
            catch (InterruptedException e) {
                return;
            }
            ProgressReporter reporter;
            while ((reporter = (ProgressReporter)this.ref.get()) != null) {
                if (reporter.cancelled || reporter.finished) {
                    return;
                }
                if (reporter.informListeners) {
                    reporter.checkListeners();
                    ++this.informListenersWasSet;
                    if (!(this.informListenersWasSet <= 5 || this.haveWarned && this.haveTraced)) {
                        long elapsedTime = System.currentTimeMillis() - this.lastResponseTime;
                        if (!this.haveTraced && elapsedTime >= 2000L) {
                            tracer.debug((Throwable)reporter.creationStackTrace, () -> "Waiting for more than " + elapsedTime + " ms for a response");
                            this.haveTraced = true;
                        }
                        if (!this.haveWarned && elapsedTime >= 30000L) {
                            Trace.warn((Throwable)reporter.creationStackTrace, () -> "Waiting for more than " + elapsedTime + " ms for a response");
                            this.haveWarned = true;
                        }
                    }
                } else {
                    if (this.haveTraced) {
                        tracer.debug((Throwable)reporter.creationStackTrace, "Operation seemed to be responsive again");
                        this.haveTraced = false;
                    }
                    if (this.haveWarned) {
                        Trace.warn((Throwable)reporter.creationStackTrace, "Operation seemed to be responsive again");
                        this.haveWarned = false;
                    }
                    this.informListenersWasSet = 0;
                }
                reporter.informListeners = true;
                if (this.informListenersWasSet == 2) {
                    this.lastResponseTime = System.currentTimeMillis();
                }
                try {
                    Thread.sleep(this.interval);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            return;
        }
    }
}

