/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.sync.event;

public enum MonitorWaitExitType {
    NOTIFIED("The object monitor was notified"),
    INTERRUPTED("The thread was interrupted"),
    TIMED_OUT("The wait call timed out"),
    SPURIOUS_WAKEUP("The object monitor received a spurious wakeup");

    private final String description;

    private MonitorWaitExitType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public int getValue() {
        switch (this) {
            case NOTIFIED: {
                return 0;
            }
            case INTERRUPTED: {
                return 1;
            }
            case TIMED_OUT: {
                return 2;
            }
            case SPURIOUS_WAKEUP: {
                return 3;
            }
        }
        throw new IllegalArgumentException("Unknown monitor wait exit type: " + this.description);
    }

    public static MonitorWaitExitType get(int value) {
        switch (value) {
            case 0: {
                return NOTIFIED;
            }
            case 1: {
                return INTERRUPTED;
            }
            case 2: {
                return TIMED_OUT;
            }
            case 3: {
                return SPURIOUS_WAKEUP;
            }
        }
        throw new IllegalArgumentException("Unknown monitor wait exit type: " + value);
    }
}

