/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.thread;

import com.sap.jvm.profiling.core.type.HostNameManager;
import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.impl.core.type.IpAddressV4Impl;
import com.sap.jvm.profiling.impl.core.type.IpAddressV6Impl;
import com.sap.jvm.profiling.impl.net.event.NetworkTraceUtils;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.thread.SocketObjectUsage;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public class SocketObject {
    private IpAddress localAddress;
    private char localPort;
    private UTF8String localHostname;
    private IpAddress remoteAddress;
    private char remotePort;
    private SocketObjectUsage socketUsage;
    private UTF8String remoteHostname;
    private static final IpAddressV4Impl loopbackAddrV4 = new IpAddressV4Impl(2130706433);
    private static final IpAddressV6Impl loopbackAddrV6 = new IpAddressV6Impl(0L, 1L);

    public IpAddress getLocalAddress() {
        return this.localAddress;
    }

    public char getLocalPort() {
        return this.localPort;
    }

    public UTF8String getLocalHostname() {
        return this.localHostname;
    }

    public IpAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public char getRemotePort() {
        return this.remotePort;
    }

    public UTF8String getRemoteHostname() {
        return this.remoteHostname;
    }

    public String getEffectiveRemoteHostname() {
        if (this.remoteConnectionIsLoopback()) {
            return "localhost";
        }
        if (this.remoteHostname != null && !this.remoteHostname.isEmpty()) {
            return this.remoteHostname.toString();
        }
        if (this.remoteAddress != null) {
            return this.remoteAddress.toString();
        }
        return "<unknown>";
    }

    public SocketObjectUsage getSocketUsage() {
        return this.socketUsage;
    }

    public SocketObject(ResourceReader reader) throws IOException {
        boolean isIPV4 = reader.readBoolean();
        short val = reader.readUint8();
        SocketObjectUsage readSocketUsage = SocketObjectUsage.UNKNOWN;
        try {
            readSocketUsage = SocketObjectUsage.getSocketUsage(val);
        }
        catch (IllegalArgumentException e) {
            Trace.error(() -> "Cannot map " + val + " to a known SocketObjectUsage.");
        }
        this.socketUsage = readSocketUsage;
        this.localAddress = isIPV4 ? IpAddressV4Impl.read(reader) : IpAddressV6Impl.read(reader);
        this.localPort = NetworkTraceUtils.readPort(reader);
        this.remoteAddress = isIPV4 ? IpAddressV4Impl.read(reader) : IpAddressV6Impl.read(reader);
        this.remotePort = NetworkTraceUtils.readPort(reader);
    }

    public SocketObject(IpAddress localAddress, char localPort, IpAddress remoteAddress, char remotePort, SocketObjectUsage socketUsage) {
        this.localAddress = localAddress;
        this.localPort = localPort;
        this.remoteAddress = remoteAddress;
        this.remotePort = remotePort;
        this.socketUsage = socketUsage;
    }

    public boolean hasValidRemoteAddress() {
        return '\u0000' < this.remotePort && this.remotePort < '\uffff';
    }

    public void write(ResourceWriter writer) throws IOException {
        assert (this.localAddress.isIPv4() == this.remoteAddress.isIPv4());
        writer.writeBoolean(this.localAddress.isIPv4());
        writer.writeInt8(this.socketUsage.getValue());
        this.localAddress.write(writer);
        NetworkTraceUtils.writePort(writer, this.localPort);
        this.remoteAddress.write(writer);
        NetworkTraceUtils.writePort(writer, this.remotePort);
    }

    public void resolveHostnames(HostNameManager hostnameManager) {
        this.localHostname = hostnameManager.getHostName(this.localAddress);
        this.remoteHostname = hostnameManager.getHostName(this.remoteAddress);
    }

    public boolean remoteConnectionIsLoopback() {
        return this.remoteAddress.isIPv4() ? this.remoteAddress.equals(loopbackAddrV4) : this.remoteAddress.equals(loopbackAddrV6);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.socketUsage.getUsageText());
        if (this.hasValidRemoteAddress()) {
            if (this.remoteHostname != null && !this.remoteHostname.isEmpty()) {
                sb.append(this.remoteHostname);
                sb.append(',');
                sb.append(I18n._ts(I18n.TextType.XMSG, " port: "));
            } else {
                sb.append(this.remoteAddress.getAddress());
                sb.append(" : ");
            }
            sb.append((int)this.remotePort);
            sb.append(" (");
            sb.append(I18n._ts(I18n.TextType.XMSG, "local port: "));
            sb.append((int)this.localPort);
            sb.append(")");
        } else {
            if (this.localHostname != null && !this.localHostname.isEmpty()) {
                sb.append(this.localHostname);
                sb.append(',');
                sb.append(I18n._ts(I18n.TextType.XMSG, " port: "));
            } else {
                sb.append(this.localAddress.getAddress());
                sb.append(" : ");
            }
            sb.append((int)this.localPort);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.localAddress == null ? 0 : this.localAddress.hashCode());
        result = 31 * result + (this.localHostname == null ? 0 : this.localHostname.hashCode());
        result = 31 * result + this.localPort;
        result = 31 * result + (this.remoteAddress == null ? 0 : this.remoteAddress.hashCode());
        result = 31 * result + (this.remoteHostname == null ? 0 : this.remoteHostname.hashCode());
        result = 31 * result + this.remotePort;
        result = 31 * result + (this.socketUsage == null ? 0 : this.socketUsage.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SocketObject other = (SocketObject)obj;
        if (this.localAddress == null ? other.localAddress != null : !this.localAddress.equals(other.localAddress)) {
            return false;
        }
        if (this.localHostname == null ? other.localHostname != null : this.localHostname.compareToIgnoreCase(other.localHostname) != 0) {
            return false;
        }
        if (this.localPort != other.localPort || this.remotePort != other.remotePort) {
            return false;
        }
        if (this.remoteAddress == null ? other.remoteAddress != null : !this.remoteAddress.equals(other.remoteAddress)) {
            return false;
        }
        return !(this.remoteHostname == null ? other.remoteHostname != null : this.remoteHostname.compareToIgnoreCase(other.remoteHostname) != 0);
    }
}

