/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.thread;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.thread.ThreadStatus;

public enum SocketObjectUsage {
    UNKNOWN(ThreadStatus.THREAD_STATUS_UNKNOWN.getValue(), I18n._ts(I18n.TextType.XMSG, "Unknown"), I18n._ts(I18n.TextType.XMSG, "unknown"), "unknown"),
    READING(ThreadStatus.THREAD_STATUS_SOCKET_READ.getValue(), I18n._ts(I18n.TextType.XMSG, "Entry for a socket connection the thread is reading from"), I18n._ts(I18n.TextType.XMSG, "reading from"), "reading"),
    WRITING(ThreadStatus.THREAD_STATUS_SOCKET_WRITE.getValue(), I18n._ts(I18n.TextType.XMSG, "Entry for a socket connection the thread is writing to"), I18n._ts(I18n.TextType.XMSG, "writing to"), "writing"),
    ACCEPTING(ThreadStatus.THREAD_STATUS_SOCKET_ACCEPT.getValue(), I18n._ts(I18n.TextType.XMSG, "Entry for a server socket object waiting for a client connection"), I18n._ts(I18n.TextType.XMSG, "waiting for new connection at"), "accepting"),
    CONNECTING(ThreadStatus.THREAD_STATUS_SOCKET_CONNECT.getValue(), I18n._ts(I18n.TextType.XMSG, "Entry for a client socket object trying to connect a server"), I18n._ts(I18n.TextType.XMSG, "connecting to"), "connecting");

    private final String description;
    private final String usageText;
    private final String tag;
    private final int value;

    private SocketObjectUsage(int value, String description, String usageText, String tag) {
        this.value = value;
        this.description = description;
        this.usageText = usageText;
        this.tag = tag;
    }

    public int getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsageText() {
        return this.usageText;
    }

    public String getTag() {
        return this.tag;
    }

    public static SocketObjectUsage getSocketUsage(int value) {
        SocketObjectUsage[] usages = SocketObjectUsage.values();
        if (value >= 0 && value < usages.length && usages[value].value == value) {
            return usages[value];
        }
        for (int i = 0; i < usages.length; ++i) {
            if (usages[i].value != value) continue;
            return usages[i];
        }
        throw new IllegalArgumentException("Unknown socket object usage: " + value);
    }
}

