/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.thread;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.impl.thread.ThreadDumpsImpl;
import com.sap.jvm.profiling.impl.thread.ThreadDumpsSummaryImpl;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumpFileParser;
import com.sap.jvm.profiling.thread.ThreadDumpsNotMatchException;
import com.sap.jvm.profiling.thread.ThreadDumpsSummary;
import com.sap.jvm.tracing.Trace;

public final class ThreadDumpFactory {
    private static final String FILEPARSER_IMPLEMENTATION_CLASS = "com.sap.jvm.profiling.impl.thread.parser.ThreadDumpFileParserImpl";

    public static ThreadDumpFileParser create() {
        try {
            Class<?> clazz = Class.forName(FILEPARSER_IMPLEMENTATION_CLASS);
            return (ThreadDumpFileParser)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception ex) {
            Trace.error(ex);
            throw new InternalError();
        }
    }

    public static ThreadDumpsSummary createThreadDumpSummary(ThreadDump[] dumps, ProfilingSession session, ProgressReporter reporter) throws ThreadDumpsNotMatchException, OperationCanceledException {
        ThreadDumpsSummaryImpl summary = null;
        if (dumps.length > 0) {
            ThreadDumpsImpl threadDumps = new ThreadDumpsImpl(dumps, session, reporter);
            summary = new ThreadDumpsSummaryImpl(threadDumps);
        }
        return summary;
    }
}

