/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.thread;

import com.sap.jvm.profiling.thread.SocketObject;
import com.sap.jvm.profiling.thread.ThreadDump;
import com.sap.jvm.profiling.thread.ThreadDumps;
import java.util.List;

public interface ThreadDumpsSummary {
    public ThreadDumps getThreadDumps();

    public int getNumThreadsDiff(int var1, int var2);

    public int getNumThreadsDiff();

    public long getNumThreads(int var1);

    public long getCPUTimeDiff(int var1, int var2);

    public long getCPUTimeDiff();

    public double getCPUUtilization();

    public double getCPUUtilization(int var1, int var2);

    public long getElapsedTimeDiff(int var1, int var2);

    public long getElapsedTimeDiff();

    public long getMemoryConsumptionDiff(int var1, int var2);

    public long getMemoryConsumptionDiff();

    public long getFileBytesReadDiff(int var1, int var2);

    public long getFileBytesReadDiff();

    public long getFileBytesWrittenDiff(int var1, int var2);

    public long getFileBytesWrittenDiff();

    public long getSocketBytesReadDiff(int var1, int var2);

    public long getSocketBytesReadDiff();

    public long getSocketBytesWrittenDiff(int var1, int var2);

    public long getSocketBytesWrittenDiff();

    public long getNumFilesOpenDiff(int var1, int var2);

    public long getNumFilesOpenDiff();

    public long getNumFilesOpen(int var1);

    public long getNumSocketsOpenDiff(int var1, int var2);

    public long getNumSocketsOpenDiff();

    public long getNumSocketsOpen(int var1);

    public ThreadDump hasDeadlock();

    public int getNumSurvivingThreads();

    public int getNumCreatedThreads();

    public int getNumFinishedThreads();

    public int getMaxNumThreads();

    public int getTotalNumThreads();

    public long getNumBlockedThreads(int var1);

    public long getNumIOThreads(int var1);

    public ThreadStateStatistic getNumThreadState();

    public List<SocketObject> getSocketConnections();

    public static class SocketConnection {
        public final String hostname;
        public final int port;

        public SocketConnection(String hostname, int port) {
            this.hostname = hostname;
            this.port = port;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.hostname == null ? 0 : this.hostname.hashCode());
            result = 31 * result + this.port;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SocketConnection other = (SocketConnection)obj;
            if (this.hostname == null ? other.hostname != null : !this.hostname.equals(other.hostname)) {
                return false;
            }
            return this.port == other.port;
        }
    }

    public static class ThreadStateStatistic {
        public final int numWaiting;
        public final int numLocked;
        public final int numIO;
        public final int numSleeping;
        public final int numRunnable;
        public final int total;

        public ThreadStateStatistic(int numWaiting, int numLocked, int numIO, int numSleeping, int numRunnable) {
            this.numWaiting = numWaiting;
            this.numLocked = numLocked;
            this.numIO = numIO;
            this.numSleeping = numSleeping;
            this.numRunnable = numRunnable;
            this.total = numWaiting + numLocked + numIO + numSleeping + numRunnable;
        }
    }
}

