/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.thread;

import com.sap.jvm.profiling.i18n.I18n;

public enum ThreadPriority {
    INIT_PRIORITY(-1, I18n._ts(I18n.TextType.XTOL, "unspecified"), I18n._ts(I18n.TextType.XTOL, "Initial non-priority value")),
    UNKNOWN_PRIORITY(0, I18n._ts(I18n.TextType.XTOL, "unknown"), I18n._ts(I18n.TextType.XTOL, "Unknown priority")),
    MIN_PRIORITY(1, I18n._ts(I18n.TextType.XTOL, "minimum"), I18n._ts(I18n.TextType.XTOL, "Minimum priority")),
    MIN_P_PRIORITY(2, I18n._ts(I18n.TextType.XTOL, "minimum+"), I18n._ts(I18n.TextType.XTOL, "More that minimum priority")),
    MIN_PP_PRIORITY(3, I18n._ts(I18n.TextType.XTOL, "minimum++"), I18n._ts(I18n.TextType.XTOL, "Much more that minimum priority")),
    NORM_M_PRIORITY(4, I18n._ts(I18n.TextType.XTOL, "normal-"), I18n._ts(I18n.TextType.XTOL, "Less than normal priority")),
    NORM_PRIORITY(5, I18n._ts(I18n.TextType.XTOL, "normal"), I18n._ts(I18n.TextType.XTOL, "Normal priority")),
    NORM_P_PRIORITY(6, I18n._ts(I18n.TextType.XTOL, "normal+"), I18n._ts(I18n.TextType.XTOL, "More than normal priority")),
    NORM_PP_PRIORITY(7, I18n._ts(I18n.TextType.XTOL, "normal++"), I18n._ts(I18n.TextType.XTOL, "Much more than normal priority")),
    HIGH_M_PRIORITY(8, I18n._ts(I18n.TextType.XTOL, "high-"), I18n._ts(I18n.TextType.XTOL, "Less than high priority")),
    HIGH_PRIORITY(9, I18n._ts(I18n.TextType.XTOL, "high"), I18n._ts(I18n.TextType.XTOL, "High priority")),
    MAX_PRIORITY(10, I18n._ts(I18n.TextType.XTOL, "maximum"), I18n._ts(I18n.TextType.XTOL, "Maximum priority"));

    private final String description;
    private final String displayText;
    private final int value;

    private ThreadPriority(int value, String displayText, String description) {
        this.value = value;
        this.displayText = displayText;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public int getValue() {
        return this.value;
    }

    public static ThreadPriority getThreadPriority(int value) {
        ThreadPriority[] priorities = ThreadPriority.values();
        for (int i = 0; i < priorities.length; ++i) {
            if (priorities[i].value != value) continue;
            return priorities[i];
        }
        throw new IllegalArgumentException("Unknown thread priority " + value);
    }
}

