/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.thread;

import com.sap.jvm.profiling.i18n.I18n;
import java.util.HashMap;
import java.util.Map;

public enum ThreadStatus {
    THREAD_STATUS_UNKNOWN(0, I18n._ts(I18n.TextType.XTOL, "Unknown"), I18n._ts(I18n.TextType.XMSG, "Unknown"), I18n._ts(I18n.TextType.XMSG, "Unknown")),
    THREAD_STATUS_RUNNING(1, I18n._ts(I18n.TextType.XTOL, "Running"), I18n._ts(I18n.TextType.XMSG, "Running"), I18n._ts(I18n.TextType.XMSG, "Running")),
    THREAD_STATUS_SLEEPING(2, I18n._ts(I18n.TextType.XTOL, "Thread.sleep()"), I18n._ts(I18n.TextType.XMSG, "Sleeping"), I18n._ts(I18n.TextType.XMSG, "Sleeping")),
    THREAD_STATUS_OS_SLEEPING(3, I18n._ts(I18n.TextType.XTOL, "Sleeping in native call, e.g. Socket.write()"), I18n._ts(I18n.TextType.XMSG, "OS Sleeping"), I18n._ts(I18n.TextType.XMSG, "OS Sleeping")),
    THREAD_STATUS_LOCK_WAIT(4, I18n._ts(I18n.TextType.XTOL, "Waiting on a lock"), I18n._ts(I18n.TextType.XMSG, "Blocked"), I18n._ts(I18n.TextType.XMSG, "Blocked")),
    THREAD_STATUS_OBJECT_WAIT(5, I18n._ts(I18n.TextType.XTOL, "Waiting in an Object.wait() call"), I18n._ts(I18n.TextType.XMSG, "Waiting"), I18n._ts(I18n.TextType.XMSG, "Waiting")),
    THREAD_STATUS_SOCKET_READ(6, I18n._ts(I18n.TextType.XTOL, "Reading from a socket endpoint"), I18n._ts(I18n.TextType.XMSG, "Socket read"), I18n._ts(I18n.TextType.XMSG, "Socket read")),
    THREAD_STATUS_SOCKET_WRITE(7, I18n._ts(I18n.TextType.XTOL, "Writing to a socket endpoint"), I18n._ts(I18n.TextType.XMSG, "Socket write"), I18n._ts(I18n.TextType.XMSG, "Socket write")),
    THREAD_STATUS_SOCKET_ACCEPT(8, I18n._ts(I18n.TextType.XTOL, "Waiting for a client socket"), I18n._ts(I18n.TextType.XMSG, "Socket accept"), I18n._ts(I18n.TextType.XMSG, "Socket accept")),
    THREAD_STATUS_SOCKET_CONNECT(9, I18n._ts(I18n.TextType.XTOL, "Waiting for a server socket"), I18n._ts(I18n.TextType.XMSG, "Socket connect"), I18n._ts(I18n.TextType.XMSG, "Socket connect")),
    THREAD_STATUS_FILE_WRITE(10, I18n._ts(I18n.TextType.XTOL, "Writing to file"), I18n._ts(I18n.TextType.XMSG, "File write"), I18n._ts(I18n.TextType.XMSG, "File write")),
    THREAD_STATUS_FILE_READ(11, I18n._ts(I18n.TextType.XTOL, "Reading from file"), I18n._ts(I18n.TextType.XMSG, "File read"), I18n._ts(I18n.TextType.XMSG, "File read"));

    private final String description;
    private final String displayText;
    private final String exportText;
    private final int value;
    static Map<String, ThreadStatus> specialMethods;

    private ThreadStatus(int value, String description, String displayText, String exportText) {
        this.value = value;
        this.displayText = displayText;
        this.exportText = exportText;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public String getExportText() {
        return this.exportText;
    }

    public int getValue() {
        return this.value;
    }

    public static ThreadStatus getThreadState(int value) {
        ThreadStatus[] threadStates = ThreadStatus.values();
        if (value >= 0 && value < threadStates.length && threadStates[value].value == value) {
            return threadStates[value];
        }
        for (int i = 0; i < threadStates.length; ++i) {
            if (threadStates[i].value != value) continue;
            return threadStates[i];
        }
        throw new IllegalArgumentException("Unknown thread state " + value);
    }

    public static ThreadStatus isSpecialMethod(String methodName) {
        return specialMethods.get(methodName);
    }

    static {
        specialMethods = new HashMap<String, ThreadStatus>();
        specialMethods.put("com.sap.jvm.inspector.filesocket.FileSocketImpl.read0", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("com.sap.jvm.inspector.filesocket.FileSocketImpl.write0", THREAD_STATUS_SOCKET_WRITE);
        specialMethods.put("com.sap.jvm.inspector.filesocket.FileSocketImpl.accept0", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("com.sap.jvm.inspector.filesocket.FileSocketImpl.connect0", THREAD_STATUS_SOCKET_CONNECT);
        specialMethods.put("java.lang.Thread.sleep", THREAD_STATUS_SLEEPING);
        specialMethods.put("java.net.PlainDatagramSocketImpl.connect0", THREAD_STATUS_SOCKET_CONNECT);
        specialMethods.put("java.net.PlainDatagramSocketImpl.send", THREAD_STATUS_SOCKET_WRITE);
        specialMethods.put("java.net.PlainDatagramSocketImpl.peek", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("java.net.PlainDatagramSocketImpl.peekData", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("java.net.PlainDatagramSocketImpl.receive0", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("java.net.PlainSocketImpl.socketConnect", THREAD_STATUS_SOCKET_CONNECT);
        specialMethods.put("java.net.PlainSocketImpl.socketAccept", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("java.net.PlainSocketImpl.socketSendUrgentData", THREAD_STATUS_SOCKET_WRITE);
        specialMethods.put("java.net.PlainSocketImpl.connect", THREAD_STATUS_SOCKET_CONNECT);
        specialMethods.put("java.net.SocketInputStream.socketRead0", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("java.net.SocketOutputStream.socketWrite0", THREAD_STATUS_SOCKET_WRITE);
        specialMethods.put("java.net.DualStackPlainDatagramSocketImpl.socketConnect", THREAD_STATUS_SOCKET_CONNECT);
        specialMethods.put("java.net.DualStackPlainDatagramSocketImpl.socketReceiveOrPeekData", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("java.net.DualStackPlainDatagramSocketImpl.socketSend", THREAD_STATUS_SOCKET_WRITE);
        specialMethods.put("java.net.DualStackPlainSocketImpl.connect0", THREAD_STATUS_SOCKET_CONNECT);
        specialMethods.put("java.net.DualStackPlainSocketImpl.waitForConnect", THREAD_STATUS_SOCKET_CONNECT);
        specialMethods.put("java.net.DualStackPlainSocketImpl.accept0", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("java.net.TwoStacksPlainDatagramSocketImpl.connect0", THREAD_STATUS_SOCKET_CONNECT);
        specialMethods.put("java.net.TwoStacksPlainDatagramSocketImpl.send", THREAD_STATUS_SOCKET_WRITE);
        specialMethods.put("java.net.TwoStacksPlainDatagramSocketImpl.peek", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("java.net.TwoStacksPlainDatagramSocketImpl.peekData", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("java.net.TwoStacksPlainDatagramSocketImpl.receive0", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("java.net.TwoStacksPlainSocketImpl.socketConnect", THREAD_STATUS_SOCKET_CONNECT);
        specialMethods.put("java.net.TwoStacksPlainSocketImpl.socketAccept", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("java.net.TwoStacksPlainSocketImpl.socketSendUrgentData", THREAD_STATUS_SOCKET_WRITE);
        specialMethods.put("sun.nio.ch.ServerSocketChannelImpl.accept", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("sun.nio.ch.ServerSocketChannelImpl.accept0", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("sun.nio.ch.ServerSocketChannelImpl.connect", THREAD_STATUS_SOCKET_CONNECT);
        specialMethods.put("com.sap.bc.proj.jstartup.fca.impl2.FCAConnection.getInBuf2", THREAD_STATUS_UNKNOWN);
        specialMethods.put("sun.nio.ch.PollArrayWrapper.poll0", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("sun.nio.ch.DevPollArrayWrapper.poll0", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("sun.nio.ch.EPollArrayWrapper.epollWait", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("sun.nio.ch.WindowsSelectorImpl$SubSelector.poll0", THREAD_STATUS_SOCKET_READ);
        specialMethods.put("com.sap.bc.proj.jstartup.fca.FCAServer.accept1", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("com.sap.mw.rfc.driver.CpicDriver.nativeSAP_CMLISTEN", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("com.sap.mw.rfc.driver.CpicDriver.nativeSAP_CMACCPTP", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("com.sap.conn.rfc.driver.CpicDriver.nativeSAP_CMLISTEN", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("com.sap.conn.rfc.driver.CpicDriver.nativeSAP_CMACCPTP", THREAD_STATUS_SOCKET_ACCEPT);
        specialMethods.put("java.io.FileInputStream.readBytes", THREAD_STATUS_FILE_READ);
        specialMethods.put("java.io.FileInputStream.writeBytes", THREAD_STATUS_FILE_WRITE);
        specialMethods.put("sun.awt.windows.WToolkit.eventLoop", THREAD_STATUS_OBJECT_WAIT);
        specialMethods.put("sun.print.Win32PrintServiceLookup.notifyPrinterChange", THREAD_STATUS_OBJECT_WAIT);
        specialMethods.put("org.eclipse.swt.internal.win32.OS.WaitMessage", THREAD_STATUS_UNKNOWN);
        specialMethods.put("org.eclipse.swt.internal.win32.OS.PeekMessageW", THREAD_STATUS_UNKNOWN);
    }
}

