/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.thread.command;

import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.EOFException;
import java.io.IOException;
import java.io.Serializable;

public final class ThreadDumpConfiguration
implements Serializable {
    private static final long serialVersionUID = 6920709983841880359L;
    private int numThreadDumps;
    private long period;
    private long delay;

    public ThreadDumpConfiguration() {
        this.numThreadDumps = 1;
        this.period = 10000L;
        this.delay = 0L;
    }

    public ThreadDumpConfiguration(int numThreadDumps, long period, long delay) {
        this.numThreadDumps = numThreadDumps;
        this.period = period;
        this.delay = delay;
    }

    public static ThreadDumpConfiguration read(ResourceReader reader) throws EOFException {
        ThreadDumpConfiguration result = new ThreadDumpConfiguration();
        result.setNumThreadDumps(reader.readInt32());
        result.setPeriod(reader.readInt64());
        result.setDelay(reader.readInt64());
        return result;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.numThreadDumps);
        writer.writeInt64(this.period);
        writer.writeInt64(this.delay);
    }

    public int getNumThreadDumps() {
        return this.numThreadDumps;
    }

    public void setNumThreadDumps(int numThreadDumps) {
        this.numThreadDumps = numThreadDumps;
    }

    public boolean unlimitedDumps() {
        return this.numThreadDumps == Integer.MAX_VALUE;
    }

    public void setUnlimitedDumps() {
        this.numThreadDumps = Integer.MAX_VALUE;
    }

    public long getPeriod() {
        return this.period;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }
}

