/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util;

import com.sap.jvm.profiling.util.AccessibleObjectWrapper;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class CtorWrapper
extends AccessibleObjectWrapper {
    private final Constructor<?> ctor;

    private static Class<?> getClass(String name, ClassLoader loader) {
        try {
            return Class.forName(name, true, loader);
        }
        catch (ClassNotFoundException e) {
            Trace.error((Throwable)e, () -> "Could not load class " + name);
            throw new RuntimeException(e);
        }
    }

    public CtorWrapper(Class<?> clazz, AccessibleObjectWrapper.SetAccessibleHook hook, Class<?> ... types) {
        this(clazz, "", hook, types);
    }

    public CtorWrapper(String clazz, ClassLoader loader, AccessibleObjectWrapper.SetAccessibleHook hook, Class<?> ... types) {
        this(CtorWrapper.getClass(clazz, loader), "", hook, types);
    }

    public CtorWrapper(Class<?> clazz, String extraInformation, AccessibleObjectWrapper.SetAccessibleHook hook, Class<?> ... types) {
        this.extraInformation = ": " + extraInformation;
        try {
            this.ctor = clazz.getConstructor(types);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Trace.error((Throwable)e, () -> "Could not get the constructor " + this.extraInformation);
            throw new RuntimeException(e);
        }
        try {
            hook.setAccessible(this.ctor);
        }
        catch (SecurityException e) {
            Trace.error((Throwable)e, () -> "Could not make the constructoraccessible " + this.extraInformation);
            throw new RuntimeException(e);
        }
    }

    public static boolean hasConstructor(Class<?> clazz, Class<?> ... types) {
        try {
            clazz.getConstructor(types);
            return true;
        }
        catch (NoSuchMethodException | SecurityException e) {
            return false;
        }
    }

    public Object newInstance(Object ... arguments) {
        try {
            return this.ctor.newInstance(arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            Trace.error(e, "Could not create instance via %s %s", this.ctor.toString(), this.extraInformation);
            throw new RuntimeException(e);
        }
    }

    public Object newInstanceWithIOException(Object ... arguments) throws IOException {
        try {
            return this.ctor.newInstance(arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
            Trace.error(e, "Could not create instance via %s %s", this.ctor.toString(), this.extraInformation);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)e.getTargetException();
            }
            Trace.error(e, "Could not create instance via %s %s", this.ctor.toString(), this.extraInformation);
            throw new RuntimeException(e);
        }
    }
}

