/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util;

import java.text.NumberFormat;

public class FormatUtils {
    private static final long NANO_SCALE = 1L;
    private static final long MICRO_SCALE = 1000L;
    private static final long MILLI_SCALE = 1000000L;
    private static final long SECOND_SCALE = 1000000000L;
    private static final int HOUR = 3600000;
    private static final int MINUTE = 60000;
    private static final int SECONDS = 1000;
    private static final int NANOS_PER_MILLI = 1000000;
    private static final NumberFormat integerFormat = NumberFormat.getInstance();
    private static final NumberFormat durationFormat1 = NumberFormat.getInstance();
    private static final NumberFormat durationFormat2 = NumberFormat.getInstance();

    public static String formattedDuration(long elapsed) {
        return FormatUtils.getElapseNanoSeconds(elapsed * 1L, 1L);
    }

    public static String formattedTimeStamp(long timestamp) {
        return FormatUtils.getDurationAsNanoseconds(timestamp);
    }

    public static String getElapseNanoSeconds(long elapsed, long minUnit) {
        if (minUnit > 60000000000L) {
            return FormatUtils.getDurationAsHHMMSS(elapsed);
        }
        if (minUnit >= 1000000000L) {
            return FormatUtils.getDurationAsSeconds(elapsed, false);
        }
        if (minUnit >= 1000000L) {
            return FormatUtils.getDurationAsMilliseconds(elapsed, false);
        }
        if (minUnit >= 1000L) {
            return FormatUtils.getDurationAsMicroseconds(elapsed, false);
        }
        return FormatUtils.getDurationAsNanoseconds(elapsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getDurationAsString(long duration, String unit, boolean onlyWholeNumbers) {
        if (onlyWholeNumbers || duration >= 10000L) {
            NumberFormat numberFormat = integerFormat;
            synchronized (numberFormat) {
                return integerFormat.format(duration / 100L) + " " + unit;
            }
        }
        if (duration < 1000L) {
            if (duration % 100L != 0L && duration % 10L != 0L) {
                NumberFormat numberFormat = durationFormat2;
                synchronized (numberFormat) {
                    return durationFormat2.format((double)duration / 100.0) + " " + unit;
                }
            }
            if (duration % 100L != 0L) {
                NumberFormat numberFormat = durationFormat1;
                synchronized (numberFormat) {
                    return durationFormat1.format((double)duration / 100.0) + " " + unit;
                }
            }
            NumberFormat numberFormat = integerFormat;
            synchronized (numberFormat) {
                return integerFormat.format(duration / 100L) + " " + unit;
            }
        }
        if (duration % 100L != 0L) {
            NumberFormat numberFormat = durationFormat1;
            synchronized (numberFormat) {
                return durationFormat1.format((double)duration / 100.0) + " " + unit;
            }
        }
        NumberFormat numberFormat = integerFormat;
        synchronized (numberFormat) {
            return integerFormat.format(duration / 100L) + " " + unit;
        }
    }

    private static String getDurationAsSeconds(long duration, boolean onlyWholeNumbers) {
        return FormatUtils.getDurationAsString(duration * 100L / 1000000000L, "s", onlyWholeNumbers);
    }

    private static String getDurationAsMilliseconds(long duration, boolean onlyWholeNumbers) {
        return FormatUtils.getDurationAsString(duration * 100L / 1000000L, "ms", onlyWholeNumbers);
    }

    private static String getDurationAsMicroseconds(long duration, boolean onlyWholeNumbers) {
        return FormatUtils.getDurationAsString(duration * 100L / 1000L, "us", onlyWholeNumbers);
    }

    private static String getDurationAsNanoseconds(long duration) {
        return FormatUtils.getDurationAsString(duration * 100L / 1L, "ns", true);
    }

    private static String getDurationAsHHMMSS(long duration) {
        long durationMillis = duration / 1000000L;
        long hours = durationMillis / 3600000L;
        long minutes = (durationMillis -= hours * 3600000L) / 60000L;
        long seconds = (durationMillis -= minutes * 60000L) / 1000L;
        durationMillis -= seconds * 1000L;
        StringBuffer buffer = new StringBuffer();
        if (hours > 0L) {
            buffer.append(hours).append("h ");
        }
        if (hours > 0L || minutes > 0L) {
            if (minutes < 10L && hours > 0L) {
                buffer.append('0');
            }
            buffer.append(minutes).append("m ");
        }
        if (seconds < 10L && (hours > 0L || minutes > 0L)) {
            buffer.append('0');
        }
        buffer.append(seconds).append('.');
        if (durationMillis < 10L) {
            buffer.append("00");
        } else if (durationMillis < 100L) {
            buffer.append('0');
        }
        buffer.append(durationMillis).append('s');
        return buffer.toString();
    }

    static {
        durationFormat1.setMinimumFractionDigits(1);
        durationFormat1.setMaximumFractionDigits(1);
        durationFormat2.setMinimumFractionDigits(2);
        durationFormat2.setMaximumFractionDigits(2);
    }
}

