/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util;

import com.sap.jvm.profiling.util.GlobMatch;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Glob {
    private final Pattern pattern;
    private final Matcher matcher;
    private final boolean starAtFront;
    private final boolean starAtEnd;

    public Glob(String glob) {
        String optPattern = glob.replaceAll("[*]+", Matcher.quoteReplacement("*"));
        this.starAtFront = optPattern.indexOf(42) == 0;
        boolean bl = this.starAtEnd = optPattern.lastIndexOf(42) == optPattern.length() - 1;
        if (this.starAtFront) {
            optPattern = optPattern.substring(1);
        }
        if (this.starAtEnd && optPattern.length() > 0) {
            optPattern = optPattern.substring(0, optPattern.length() - 1);
        }
        if (optPattern.length() == 0) {
            this.matcher = null;
            this.pattern = null;
            return;
        }
        StringBuilder regexp = new StringBuilder();
        int starPos = optPattern.indexOf(42);
        int markPos = optPattern.indexOf(63);
        int pos = 0;
        while (starPos >= 0 || markPos >= 0) {
            int begin = markPos < 0 ? starPos : (starPos < 0 ? markPos : Math.min(markPos, starPos));
            if (pos < begin) {
                regexp.append(Pattern.quote(optPattern.substring(pos, begin)));
            }
            int nrOfMarks = 0;
            boolean hasStars = false;
            for (pos = begin; pos < optPattern.length(); ++pos) {
                char c = optPattern.charAt(pos);
                if (c == '?') {
                    ++nrOfMarks;
                    continue;
                }
                if (c != '*') break;
                hasStars = true;
            }
            if (hasStars) {
                if (nrOfMarks == 0) {
                    regexp.append(".*");
                } else {
                    regexp.append(".{" + nrOfMarks + ",}");
                }
            } else {
                assert (nrOfMarks >= 1);
                if (nrOfMarks == 1) {
                    regexp.append('.');
                } else {
                    regexp.append(".{" + nrOfMarks + "}");
                }
            }
            starPos = optPattern.indexOf(42, pos);
            markPos = optPattern.indexOf(63, pos);
        }
        if (pos < optPattern.length()) {
            regexp.append(Pattern.quote(optPattern.substring(pos)));
        }
        this.pattern = Pattern.compile(regexp.toString());
        this.matcher = this.pattern.matcher("");
    }

    private Glob(Pattern pattern, boolean starAtFront, boolean starAtEnd) {
        this.pattern = pattern;
        this.matcher = pattern == null ? null : pattern.matcher("");
        this.starAtFront = starAtFront;
        this.starAtEnd = starAtEnd;
    }

    public Glob copy() {
        return new Glob(this.pattern, this.starAtFront, this.starAtEnd);
    }

    public boolean isMatch(String text) {
        if (this.pattern == null) {
            return this.starAtFront;
        }
        this.matcher.reset(text);
        return this.matcher.find();
    }

    public boolean isFullMatch(String text) {
        if (this.pattern == null) {
            return this.starAtFront;
        }
        this.matcher.reset(text);
        if (!this.matcher.find()) {
            return false;
        }
        if (this.starAtFront) {
            if (this.starAtEnd) {
                return true;
            }
            return this.matcher.end() == text.length();
        }
        if (this.starAtEnd) {
            return this.matcher.start() == 0;
        }
        return this.matcher.start() == 0 && this.matcher.end() == text.length();
    }

    public GlobMatch getFirstMatch(String text) {
        if (this.pattern == null) {
            if (this.starAtFront) {
                return new GlobMatch(0, text.length());
            }
            return null;
        }
        this.matcher.reset(text);
        if (!this.matcher.find()) {
            return null;
        }
        if (this.starAtFront) {
            if (this.starAtEnd) {
                return new GlobMatch(0, text.length());
            }
            return new GlobMatch(0, this.matcher.end());
        }
        if (this.starAtEnd) {
            assert (!this.starAtFront);
            return new GlobMatch(this.matcher.start(), text.length());
        }
        return new GlobMatch(this.matcher.start(), this.matcher.end());
    }

    public GlobMatch[] getAllMatches(String text) {
        if (this.pattern == null) {
            if (this.starAtFront) {
                return new GlobMatch[]{new GlobMatch(0, text.length())};
            }
            return null;
        }
        this.matcher.reset(text);
        if (!this.matcher.find()) {
            return null;
        }
        if (this.starAtFront) {
            if (this.starAtEnd) {
                return new GlobMatch[]{new GlobMatch(0, text.length())};
            }
            int end = this.matcher.end();
            while (this.matcher.find()) {
                end = this.matcher.end();
            }
            return new GlobMatch[]{new GlobMatch(0, end)};
        }
        if (this.starAtEnd) {
            assert (!this.starAtFront);
            return new GlobMatch[]{new GlobMatch(this.matcher.start(), text.length())};
        }
        ArrayList<GlobMatch> result = new ArrayList<GlobMatch>();
        do {
            result.add(new GlobMatch(this.matcher.start(), this.matcher.end()));
        } while (this.matcher.find());
        return result.toArray(new GlobMatch[result.size()]);
    }
}

