/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util;

public final class IdentityHashSet {
    private static final double MAX_LOAD = 0.75;
    private Object[] buckets;
    private int mask;
    private int nrOfEntries;
    private int maxNrOfEntries;

    public IdentityHashSet() {
        this.buckets = new Object[64];
        this.mask = 63;
        this.maxNrOfEntries = (int)((double)(this.mask + 1) * 0.75);
    }

    public IdentityHashSet(int nrOfBuckets) {
        int pow2;
        assert (nrOfBuckets > 0);
        for (pow2 = 1; pow2 < nrOfBuckets; pow2 *= 2) {
        }
        this.buckets = new Object[pow2];
        this.mask = pow2 - 1;
        this.maxNrOfEntries = (int)((double)(this.mask + 1) * 0.75);
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = null;
        }
        this.nrOfEntries = 0;
    }

    public int size() {
        return this.nrOfEntries;
    }

    public boolean isEmpty() {
        return this.nrOfEntries == 0;
    }

    public <T> T[] copyToArray(T[] array) {
        int off = 0;
        for (Object o : this.buckets) {
            if (o == null) continue;
            array[off] = o;
            ++off;
        }
        return array;
    }

    public boolean add(Object entry) {
        int bucket;
        int i;
        assert (entry != null);
        for (i = bucket = entry.hashCode() & this.mask; i <= this.mask; ++i) {
            if (this.buckets[i] == null) {
                ++this.nrOfEntries;
                this.buckets[i] = entry;
                this.adjustSizeIfNeeded();
                return true;
            }
            if (this.buckets[i] != entry) continue;
            return false;
        }
        for (i = 0; i < bucket; ++i) {
            if (this.buckets[i] == null) {
                ++this.nrOfEntries;
                this.buckets[i] = entry;
                this.adjustSizeIfNeeded();
                return true;
            }
            if (this.buckets[i] != entry) continue;
            return false;
        }
        assert (false);
        return false;
    }

    public boolean contains(Object entry) {
        int bucket;
        int i;
        assert (entry != null);
        for (i = bucket = entry.hashCode() & this.mask; i <= this.mask; ++i) {
            if (this.buckets[i] == null) {
                return false;
            }
            if (this.buckets[i] != entry) continue;
            return true;
        }
        for (i = 0; i < bucket; ++i) {
            if (this.buckets[i] == null) {
                return false;
            }
            if (this.buckets[i] != entry) continue;
            return true;
        }
        assert (false);
        return false;
    }

    private void adjustSizeIfNeeded() {
        if (this.nrOfEntries == this.maxNrOfEntries) {
            this.maxNrOfEntries *= 2;
            this.mask = this.mask * 2 + 1;
            Object[] oldBuckets = this.buckets;
            this.buckets = new Object[oldBuckets.length * 2];
            this.nrOfEntries = 0;
            for (int i = 0; i < oldBuckets.length; ++i) {
                if (oldBuckets[i] == null) continue;
                this.add(oldBuckets[i]);
            }
        }
    }
}

