/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util;

import java.util.Arrays;

public final class IntArrayList {
    private int[] data = new int[32];
    private int len;

    public int get(int index) {
        assert (index < this.len);
        return this.data[index];
    }

    public void set(int index, int value) {
        assert (index < this.len);
        this.data[index] = value;
    }

    public void setSize(int size) {
        assert (size >= 0);
        this.ensureCapacity(size);
        this.len = size;
    }

    public void push(int value) {
        this.ensureCapacity(this.len + 1);
        this.data[this.len] = value;
        ++this.len;
    }

    public void push(IntArrayList toAdd) {
        this.ensureCapacity(this.len + toAdd.len);
        System.arraycopy(toAdd.data, 0, this.data, this.len, toAdd.len);
        this.len += toAdd.len;
    }

    private void ensureCapacity(int size) {
        if (size > this.data.length) {
            int newSize = Math.max(this.data.length * 2, size);
            int[] newData = new int[newSize];
            System.arraycopy(this.data, 0, newData, 0, this.len);
            this.data = newData;
        }
    }

    public void pop() {
        assert (this.len > 0);
        --this.len;
    }

    public int getLast() {
        assert (this.len > 0);
        return this.data[this.len - 1];
    }

    public int size() {
        return this.len;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public void clear() {
        this.len = 0;
    }

    public int getMaxValue() {
        assert (this.len > 0);
        int max = this.data[0];
        for (int i = 1; i < this.len; ++i) {
            max = Math.max(max, this.data[i]);
        }
        return max;
    }

    public int getMinValue() {
        assert (this.len > 0);
        int min = this.data[0];
        for (int i = 1; i < this.len; ++i) {
            min = Math.min(min, this.data[i]);
        }
        return min;
    }

    public void sortAscendingAndUnique() {
        if (this.len <= 1) {
            return;
        }
        if (!this.isAscending()) {
            Arrays.sort(this.data, 0, this.len);
        }
        int last = this.data[0];
        int newLen = 1;
        for (int i = 1; i < this.len; ++i) {
            if (last == this.data[i]) continue;
            this.data[newLen] = last = this.data[i];
            ++newLen;
        }
        this.len = newLen;
    }

    public boolean isAscending() {
        if (this.len <= 1) {
            return true;
        }
        int last = this.data[0];
        for (int i = 1; i < this.len; ++i) {
            if (last > this.data[i]) {
                return false;
            }
            last = this.data[i];
        }
        return true;
    }

    public boolean contains(int index) {
        assert (this.isAscending());
        return Arrays.binarySearch(this.data, index) >= 0;
    }

    public void copyTo(IntArrayList other) {
        other.ensureCapacity(this.len);
        other.len = this.len;
        System.arraycopy(this.data, 0, other.data, 0, this.len);
    }
}

