/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util;

public class LongToIntConverter {
    private long[] array = new long[10];
    private int nextIndex;

    public long getValue(int rawValue) {
        if (rawValue >= 0) {
            return rawValue;
        }
        return this.array[-rawValue - 1];
    }

    public int add(int rawValue, long toAdd) {
        int result;
        assert (toAdd >= 0L);
        if (toAdd >>> 31 != 0L) {
            if (rawValue < 0) {
                int n = -rawValue - 1;
                this.array[n] = this.array[n] + toAdd;
                result = rawValue;
            } else {
                int index = this.getNextIndex();
                this.array[index] = (long)rawValue + toAdd;
                result = -index - 1;
            }
        } else if (rawValue < 0) {
            int n = -rawValue - 1;
            this.array[n] = this.array[n] + toAdd;
            result = rawValue;
        } else {
            result = rawValue + (int)toAdd;
            if (result < 0) {
                int index = this.getNextIndex();
                this.array[index] = (long)rawValue + toAdd;
                result = -index - 1;
            }
        }
        return result;
    }

    private int getNextIndex() {
        if (this.nextIndex >= this.array.length) {
            long[] newArray = new long[this.array.length * 2];
            System.arraycopy(this.array, 0, newArray, 0, this.array.length);
            this.array = newArray;
        }
        return this.nextIndex++;
    }
}

