/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util;

import com.sap.jvm.profiling.util.AccessibleObjectWrapper;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodWrapper
extends AccessibleObjectWrapper {
    private final Method method;

    private static Method getMethod(Class<?> clazz, String name, Class<?> ... types) throws SecurityException, NoSuchMethodException {
        try {
            return clazz.getMethod(name, types);
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getDeclaredMethod(name, types);
            }
            catch (NoSuchMethodException e2) {
                if (clazz.getSuperclass() != null) {
                    return MethodWrapper.getMethod(clazz.getSuperclass(), name, types);
                }
                throw e2;
            }
        }
    }

    public MethodWrapper(Class<?> clazz, String name, AccessibleObjectWrapper.SetAccessibleHook hook, Class<?> ... types) {
        this("", clazz, name, hook, types);
    }

    public MethodWrapper(String extraInformation, Class<?> clazz, String name, AccessibleObjectWrapper.SetAccessibleHook hook, Class<?> ... types) {
        this.extraInformation = ": " + extraInformation;
        try {
            this.method = MethodWrapper.getMethod(clazz, name, types);
        }
        catch (NoSuchMethodException | SecurityException e) {
            Trace.error(e, "Could not get the method %s %s", clazz.toString() + "." + name, this.extraInformation);
            throw new RuntimeException(e);
        }
        try {
            hook.setAccessible(this.method);
        }
        catch (SecurityException e) {
            Trace.error(e, "Could not make method %s accessible %s", clazz.toString() + "." + name, this.extraInformation);
            throw new RuntimeException(e);
        }
    }

    public Object invoke(Object target, Object ... arguments) {
        try {
            return this.method.invoke(target, arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Trace.error(e, "Could not invoke the method %s %s", this.method.toString(), this.extraInformation);
            throw new RuntimeException(e);
        }
    }

    public Object invokeWithIOException(Object target, Object ... arguments) throws IOException {
        try {
            return this.method.invoke(target, arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Trace.error(e, "Could not invoke the method %s %s", this.method.toString(), this.extraInformation);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)e.getTargetException();
            }
            Trace.error(e, "Could not invoke the method %s %s", this.method.toString(), this.extraInformation);
            throw new RuntimeException(e);
        }
    }
}

