/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util;

public class ObjectIdToIntHashSet {
    private static final int INITIAL_SIZE = 128;
    private Object[] keys;
    private int[] values;
    private int nrOfEntries;
    private int mask;
    private int resizeLimit;
    private final double maxLoadFactor;

    public ObjectIdToIntHashSet() {
        this(0.75);
    }

    public ObjectIdToIntHashSet(double maxLoadFactor) {
        assert (maxLoadFactor > 0.0);
        assert (maxLoadFactor < 1.0);
        this.keys = new Object[128];
        this.values = new int[128];
        this.maxLoadFactor = maxLoadFactor;
    }

    public int size() {
        return this.nrOfEntries;
    }

    public boolean contains(Object obj) {
        int bucket = obj.hashCode() & this.mask;
        Object curr = this.keys[bucket];
        while (curr != null && curr != obj) {
            bucket = bucket + 1 & this.mask;
            curr = this.keys[bucket];
        }
        return curr != null;
    }

    public int get(Object obj) {
        assert (this.contains(obj));
        int bucket = obj.hashCode() & this.mask;
        Object curr = this.keys[bucket];
        while (curr != obj) {
            bucket = bucket + 1 & this.mask;
            curr = this.keys[bucket];
        }
        return this.values[bucket];
    }

    public void add(Object obj, int value) {
        assert (!this.contains(obj));
        if (this.nrOfEntries >= this.resizeLimit) {
            Object[] oldObjects = this.keys;
            int[] oldIntegers = this.values;
            this.keys = new Object[oldObjects.length * 2];
            this.values = new int[oldObjects.length * 2];
            this.mask = this.values.length - 1;
            this.nrOfEntries = 0;
            this.resizeLimit = (int)((double)this.values.length * this.maxLoadFactor);
            for (int i = 0; i < oldObjects.length; ++i) {
                if (oldObjects[i] == null) continue;
                this.add(oldObjects[i], oldIntegers[i]);
            }
        }
        assert (!this.contains(obj));
        int bucket = obj.hashCode() & this.mask;
        Object curr = this.keys[bucket];
        while (curr != null) {
            bucket = bucket + 1 & this.mask;
            curr = this.keys[bucket];
        }
        this.keys[bucket] = obj;
        this.values[bucket] = value;
        ++this.nrOfEntries;
        assert (this.contains(obj));
    }
}

