/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util;

public final class SmallIntHashSet {
    private int[] data = new int[20];
    private int size = 0;

    public void clearAndReserve(int maxIndex) {
        int chunks = (maxIndex + 31) / 32;
        if (chunks > this.data.length) {
            this.data = new int[chunks];
        } else {
            for (int i = 0; i <= chunks; ++i) {
                this.data[i] = 0;
            }
        }
        this.size = maxIndex;
    }

    public boolean contains(int index) {
        assert (index >= 0);
        if (index >= this.size) {
            return false;
        }
        return (this.data[index / 32] & 1 << (index & 0x1F)) != 0;
    }

    public void add(int index) {
        assert (index >= 0);
        assert (index < this.size);
        int n = index / 32;
        this.data[n] = this.data[n] | 1 << (index & 0x1F);
    }
}

