/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.sets;

import java.util.Arrays;

public abstract class LongCuckooSet {
    private static final double LOAD_FACTOR = 0.45;
    private long[] hashSet = new long[0];
    private int size;
    private int tries;
    private int resizeLimit;
    private long[] overflowSet;
    private int overflowSetSize;

    protected LongCuckooSet(int capacity, long emptyValue) {
        this.resize(LongCuckooSet.getSuitableCapacity(capacity), emptyValue, 1);
    }

    protected final boolean addImpl(long toAdd, long emptyValue) {
        return this.addImpl(toAdd, emptyValue, this.tries);
    }

    private boolean addImpl(long toAdd, long emptyValue, int triesLeft) {
        assert (toAdd != emptyValue);
        assert (triesLeft >= 0);
        int part1 = (int)(toAdd & 0xFFFFFFFFFFFFFFFFL);
        int part2 = (int)(toAdd >>> 32);
        int halfSize = this.hashSet.length / 2;
        int hash1 = (part1 ^ 31 * part2) & halfSize - 1;
        if (this.hashSet[hash1] == toAdd) {
            return false;
        }
        int hash2 = halfSize + ((31 * part1 ^ part2) & halfSize - 1);
        if (this.hashSet[hash2] == toAdd) {
            return false;
        }
        if (this.overflowSet != null) {
            int mask = this.overflowSet.length - 1;
            int hash = (part1 ^ 31 * part2) & mask;
            for (int i = 0; i <= mask && this.overflowSet[i + hash & mask] != emptyValue; ++i) {
                if (this.overflowSet[i + hash & mask] != toAdd) continue;
                return false;
            }
        }
        if (this.size >= this.resizeLimit) {
            this.resize(this.hashSet.length * 2, emptyValue, triesLeft);
            halfSize = this.hashSet.length / 2;
            hash1 = (part1 ^ 31 * part2) & halfSize - 1;
            hash2 = halfSize + ((31 * part1 ^ part2) & halfSize - 1);
        }
        int tryHash1 = hash1;
        int tryHash2 = hash2;
        if ((triesLeft & 1) == 0) {
            tryHash1 = hash2;
            tryHash2 = hash1;
        }
        if (this.hashSet[tryHash1] == emptyValue) {
            this.hashSet[tryHash1] = toAdd;
            ++this.size;
            return true;
        }
        if (this.hashSet[tryHash2] == emptyValue) {
            this.hashSet[tryHash2] = toAdd;
            ++this.size;
            return true;
        }
        if (triesLeft == 0) {
            this.addToOverflowSet(toAdd, emptyValue);
            return true;
        }
        long oldValue = this.hashSet[tryHash1];
        this.hashSet[tryHash1] = toAdd;
        this.addImpl(oldValue, emptyValue, triesLeft - 1);
        return true;
    }

    protected final boolean containsImpl(long toSearch, long emptyValue) {
        assert (toSearch != emptyValue);
        int part1 = (int)(toSearch & 0xFFFFFFFFFFFFFFFFL);
        int part2 = (int)(toSearch >>> 32);
        int halfSize = this.hashSet.length / 2;
        int hash1 = (part1 ^ 31 * part2) & halfSize - 1;
        if (this.hashSet[hash1] == toSearch) {
            return true;
        }
        int hash2 = halfSize + ((31 * part1 ^ part2) & halfSize - 1);
        if (this.hashSet[hash2] == toSearch) {
            return true;
        }
        if (this.overflowSet != null) {
            int mask = this.overflowSet.length - 1;
            int hash = (part1 ^ 31 * part2) & mask;
            for (int i = 0; i <= mask; ++i) {
                if (this.overflowSet[i + hash & mask] == emptyValue) {
                    return false;
                }
                if (this.overflowSet[i + hash & mask] != toSearch) continue;
                return true;
            }
        }
        return false;
    }

    protected final boolean removeImpl(long toRemove, long emptyValue) {
        assert (toRemove != emptyValue);
        int part1 = (int)(toRemove & 0xFFFFFFFFFFFFFFFFL);
        int part2 = (int)(toRemove >>> 32);
        int halfSize = this.hashSet.length / 2;
        int hash1 = (part1 ^ 31 * part2) & halfSize - 1;
        if (this.hashSet[hash1] == toRemove) {
            this.hashSet[hash1] = emptyValue;
            --this.size;
            return true;
        }
        int hash2 = halfSize + ((31 * part1 ^ part2) & halfSize - 1);
        if (this.hashSet[hash2] == toRemove) {
            this.hashSet[hash2] = emptyValue;
            --this.size;
            return true;
        }
        if (this.overflowSet != null) {
            int mask = this.overflowSet.length - 1;
            int hash = (part1 ^ 31 * part2) & mask;
            for (int i = 0; i <= mask; ++i) {
                if (this.overflowSet[i + hash & mask] == emptyValue) {
                    return false;
                }
                if (this.overflowSet[i + hash & mask] != toRemove) continue;
                long[] oldOverflowSet = this.overflowSet;
                this.overflowSet = null;
                this.overflowSetSize = 0;
                for (int j = 1; j <= mask; ++j) {
                    long value = oldOverflowSet[i + j + hash & mask];
                    if (value == emptyValue) continue;
                    this.addToOverflowSet(value, emptyValue);
                }
                return true;
            }
        }
        return false;
    }

    protected final void clearImpl(long emptyValue) {
        Arrays.fill(this.hashSet, emptyValue);
        this.overflowSet = null;
        this.overflowSetSize = 0;
        this.size = 0;
    }

    public final int size() {
        return this.size + this.overflowSetSize;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    private void addToOverflowSet(long toAdd, long emptyValue) {
        if (this.overflowSet == null) {
            this.overflowSet = new long[8];
            Arrays.fill(this.overflowSet, emptyValue);
        } else if (this.overflowSet.length < this.overflowSetSize * 2) {
            long[] oldOverflowSet = this.overflowSet;
            this.overflowSet = new long[this.overflowSet.length * 2];
            this.overflowSetSize = 0;
            Arrays.fill(this.overflowSet, emptyValue);
            for (long value : oldOverflowSet) {
                if (value == emptyValue) continue;
                this.addToOverflowSet(value, emptyValue);
            }
        }
        int mask = this.overflowSet.length - 1;
        int part1 = (int)(toAdd & 0xFFFFFFFFFFFFFFFFL);
        int part2 = (int)(toAdd >>> 32);
        int hash = (part1 ^ 31 * part2) & mask;
        for (int i = 0; i <= mask; ++i) {
            if (this.overflowSet[i + hash & mask] != emptyValue) continue;
            this.overflowSet[i + hash & mask] = toAdd;
            ++this.overflowSetSize;
            return;
        }
        assert (false);
    }

    private void resize(int newSize, long emptyValue, int nrOfTries) {
        long[] oldHashSet = this.hashSet;
        long[] oldOverflowSet = this.overflowSet;
        this.hashSet = new long[newSize];
        Arrays.fill(this.hashSet, emptyValue);
        this.overflowSet = null;
        this.overflowSetSize = 0;
        this.size = 0;
        for (long value : oldHashSet) {
            if (value == emptyValue) continue;
            this.addImpl(value, emptyValue, nrOfTries);
        }
        if (oldOverflowSet != null) {
            for (long value : oldOverflowSet) {
                if (value == emptyValue) continue;
                this.addImpl(value, emptyValue, nrOfTries);
            }
        }
        this.resizeLimit = (int)((double)this.hashSet.length * 0.45);
        this.tries = (int)(Math.log10(this.resizeLimit) * 5.0);
    }

    private static final int getSuitableCapacity(int capacity) {
        int result = 8;
        while ((double)result * 0.45 * 2.0 < (double)capacity) {
            result *= 2;
        }
        return result;
    }

    public String toString() {
        return "A set with " + this.size() + " entries";
    }
}

