/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.sets;

import com.sap.jvm.profiling.util.splitarray.SplitArray32;
import com.sap.jvm.profiling.util.splitarray.SplitArray64;
import com.sap.jvm.util.pair.LongPair;
import java.util.Arrays;

public abstract class RangeBasedLongSet {
    private final long min;
    private final long max;

    protected RangeBasedLongSet(long[] sorted) {
        if (sorted.length == 0) {
            this.min = 1L;
            this.max = 0L;
        } else {
            this.min = sorted[0];
            this.max = sorted[sorted.length - 1];
        }
    }

    public static RangeBasedLongSet create(long[] values) {
        long[] sorted = (long[])values.clone();
        Arrays.sort(sorted);
        return new Impl64(sorted);
    }

    public abstract int getNrOfRanges();

    public abstract LongPair[] getFirstRanges(int var1);

    public boolean contains(long value) {
        return value >= this.min && value <= this.max;
    }

    private static class Impl64
    extends RangeBasedLongSet {
        private final long[] starts;
        private final int[] sizes;
        private final long[] singles;

        public Impl64(long[] sorted) {
            super(sorted);
            long lastValue;
            if (sorted.length == 0) {
                this.starts = new long[0];
                this.sizes = new int[0];
                this.singles = this.starts;
                return;
            }
            SplitArray64 tmpStarts = new SplitArray64();
            SplitArray32 tmpSizes = new SplitArray32();
            SplitArray64 tmpSingles = new SplitArray64();
            long firstValue = lastValue = sorted[0];
            int rangeSize = 1;
            for (int i = 1; i < sorted.length; ++i) {
                long curr = sorted[i];
                if (lastValue + 1L != curr) {
                    if (lastValue == firstValue) {
                        tmpSingles.add(lastValue);
                    } else {
                        tmpStarts.add(firstValue);
                        tmpSizes.add(rangeSize);
                        rangeSize = 1;
                        firstValue = curr;
                    }
                } else {
                    ++rangeSize;
                }
                lastValue = curr;
            }
            if (rangeSize == 1) {
                tmpSingles.add(lastValue);
            } else {
                tmpStarts.add(firstValue);
                tmpSizes.add(rangeSize);
            }
            this.starts = tmpStarts.toArray();
            this.sizes = tmpSizes.toArray();
            this.singles = tmpSingles.toArray();
        }

        @Override
        public int getNrOfRanges() {
            return this.singles.length + this.starts.length;
        }

        @Override
        public LongPair[] getFirstRanges(int nrOfRanges) {
            int index;
            int length = Math.min(this.getNrOfRanges(), nrOfRanges);
            int singleIndex = 0;
            int startIndex = 0;
            LongPair[] result = new LongPair[length];
            for (index = 0; index < length; ++index) {
                if (singleIndex < this.singles.length) {
                    if (startIndex < this.starts.length) {
                        if (this.singles[singleIndex] < this.starts[startIndex]) {
                            result[index] = new LongPair(this.singles[singleIndex], this.singles[singleIndex] + 1L);
                            ++singleIndex;
                            continue;
                        }
                        result[index] = new LongPair(this.starts[startIndex], this.starts[startIndex] + (long)this.sizes[startIndex - 1]);
                        ++startIndex;
                        continue;
                    }
                    result[index] = new LongPair(this.singles[singleIndex], this.singles[singleIndex] + 1L);
                    ++singleIndex;
                    continue;
                }
                result[index] = new LongPair(this.starts[startIndex], this.starts[startIndex] + (long)this.sizes[startIndex - 1]);
                ++startIndex;
            }
            assert (index == result.length);
            return result;
        }

        @Override
        public boolean contains(long value) {
            if (!super.contains(value)) {
                return false;
            }
            long checkValue = value;
            int index = Arrays.binarySearch(this.singles, checkValue);
            if (index >= 0) {
                return true;
            }
            index = Arrays.binarySearch(this.starts, checkValue);
            if (index >= 0) {
                return true;
            }
            if (index < -1) {
                return value < this.starts[index = -index - 1] + (long)this.sizes[index];
            }
            return false;
        }
    }
}

