/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.splitarray;

import java.util.Arrays;

public final class SplitArray1 {
    private static final int LOG_CHUNK_SIZE = 14;
    private static final int CHUNK_SIZE = 16384;
    private byte[][] array = new byte[0][];
    private long size;

    public SplitArray1() {
    }

    public SplitArray1(long size) {
        this.resize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(int index) {
        assert ((long)index < this.size);
        int bitIndex = index & 7;
        int arrayIndex = index >> 3;
        int index1 = arrayIndex >> 14;
        int index2 = arrayIndex & 0x3FFF;
        byte[] array1 = this.array[index1];
        if (array1 == null) {
            SplitArray1 splitArray1 = this;
            synchronized (splitArray1) {
                array1 = this.array[index1];
                assert (array1 != null);
            }
        }
        return (array1[index2] & 0xFF & 1 << bitIndex) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean get(long index) {
        assert (index < this.size);
        int bitIndex = (int)(index & 7L);
        long arrayIndex = index >> 3;
        int index1 = (int)(arrayIndex >> 14);
        int index2 = (int)(arrayIndex & 0x3FFFL);
        byte[] array1 = this.array[index1];
        if (array1 == null) {
            SplitArray1 splitArray1 = this;
            synchronized (splitArray1) {
                array1 = this.array[index1];
                assert (array1 != null);
            }
        }
        return (array1[index2] & 0xFF & 1 << bitIndex) != 0;
    }

    public void set(int index, boolean value) {
        assert ((long)index < this.size);
        int bitIndex = index & 7;
        int arrayIndex = index >> 3;
        int index1 = arrayIndex >> 14;
        int index2 = arrayIndex & 0x3FFF;
        if (value) {
            byte[] byArray = this.array[index1];
            int n = index2;
            byArray[n] = (byte)(byArray[n] | (byte)(1 << bitIndex));
        } else {
            byte[] byArray = this.array[index1];
            int n = index2;
            byArray[n] = (byte)(byArray[n] & ~((byte)(1 << bitIndex)));
        }
    }

    public void add(boolean value) {
        this.resize(this.size + 1L);
        this.set(this.size - 1L, value);
    }

    public void set(long index, boolean value) {
        assert (index < this.size);
        int bitIndex = (int)(index & 7L);
        long arrayIndex = index >> 3;
        int index1 = (int)(arrayIndex >> 14);
        int index2 = (int)(arrayIndex & 0x3FFFL);
        if (value) {
            byte[] byArray = this.array[index1];
            int n = index2;
            byArray[n] = (byte)(byArray[n] | (byte)(1 << bitIndex));
        } else {
            byte[] byArray = this.array[index1];
            int n = index2;
            byArray[n] = (byte)(byArray[n] & ~((byte)(1 << bitIndex)));
        }
    }

    public long size() {
        return this.size;
    }

    public void resize(int newSize) {
        if ((long)newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.resize((long)newSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(long newSize) {
        if (newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.size = newSize;
        long byteSize = (newSize + 7L) / 8L;
        if (byteSize <= (long)(this.array.length * 16384)) {
            return;
        }
        byte[][] newArray = new byte[(int)(byteSize + 16384L - 1L) >> 14][];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        for (int i = this.array.length; i < newArray.length; ++i) {
            newArray[i] = new byte[16384];
        }
        SplitArray1 splitArray1 = this;
        synchronized (splitArray1) {
            this.array = newArray;
        }
    }

    public void resizeAndClear(long newSize) {
        int oldNrOfChunks = this.array.length;
        this.resize(newSize);
        for (int i = 0; i < oldNrOfChunks; ++i) {
            Arrays.fill(this.array[i], (byte)0);
        }
    }
}

