/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.util.splitarray;

import java.util.Arrays;

public final class SplitArray16 {
    private static final int LOG_CHUNK_SIZE = 14;
    private static final int CHUNK_SIZE = 16384;
    private short[][] array = new short[0][];
    private long size;

    public SplitArray16() {
    }

    public SplitArray16(long size) {
        this.resize(size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(int index) {
        assert ((long)index < this.size);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        short[] array1 = this.array[index1];
        if (array1 == null) {
            SplitArray16 splitArray16 = this;
            synchronized (splitArray16) {
                array1 = this.array[index1];
                assert (array1 != null);
            }
        }
        return array1[index2] & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get(long index) {
        assert (index < this.size);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        short[] array1 = this.array[index1];
        if (array1 == null) {
            SplitArray16 splitArray16 = this;
            synchronized (splitArray16) {
                array1 = this.array[index1];
                assert (array1 != null);
            }
        }
        return array1[index2] & 0xFFFF;
    }

    public int get(int index, int bitOffset, int nrOfBits) {
        assert ((long)index < this.size);
        assert (nrOfBits <= 16);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 16);
        return this.get(index) >>> bitOffset & (1 << nrOfBits) - 1;
    }

    public int get(long index, int bitOffset, int nrOfBits) {
        assert (index < this.size);
        assert (nrOfBits <= 16);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 16);
        return this.get(index) >>> bitOffset & (1 << nrOfBits) - 1;
    }

    public void set(int index, int value) {
        assert ((long)index < this.size);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        this.array[index1][index2] = (short)value;
    }

    public void set(long index, int value) {
        assert (index < this.size);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        this.array[index1][index2] = (short)value;
    }

    public void set(int index, int value, int bitOffset, int nrOfBits) {
        assert ((long)index < this.size);
        assert (nrOfBits <= 16);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 16);
        int index1 = index >> 14;
        int index2 = index & 0x3FFF;
        short newVal = this.array[index1][index2];
        newVal = (short)(newVal & ~((1 << nrOfBits) - 1 << bitOffset));
        this.array[index1][index2] = newVal = (short)(newVal | (value & (1 << nrOfBits) - 1) << bitOffset);
    }

    public void set(long index, int value, int bitOffset, int nrOfBits) {
        assert (index < this.size);
        assert (nrOfBits <= 16);
        assert (nrOfBits > 0);
        assert (bitOffset + nrOfBits <= 16);
        int index1 = (int)(index >> 14);
        int index2 = (int)(index & 0x3FFFL);
        short newVal = this.array[index1][index2];
        newVal = (short)(newVal & ~((1 << nrOfBits) - 1 << bitOffset));
        this.array[index1][index2] = newVal = (short)(newVal | (value & (1 << nrOfBits) - 1) << bitOffset);
    }

    public void add(int value) {
        long newSize = this.size + 1L;
        if (newSize > (long)(this.array.length * 16384)) {
            this.resize(newSize);
        } else {
            this.size = newSize;
        }
        this.set(newSize - 1L, value);
    }

    public short[] toArray() {
        int sz = (int)this.size;
        short[] result = new short[sz];
        for (int i = 0; i < sz; ++i) {
            result[i] = (short)this.get(i);
        }
        return result;
    }

    public long size() {
        return this.size;
    }

    public void resize(int newSize) {
        if ((long)newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.resize((long)newSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resize(long newSize) {
        if (newSize < this.size) {
            this.size = newSize;
            return;
        }
        this.size = newSize;
        if (newSize <= (long)(this.array.length * 16384)) {
            return;
        }
        short[][] newArray = new short[(int)(newSize + 16384L - 1L) >> 14][];
        System.arraycopy(this.array, 0, newArray, 0, this.array.length);
        for (int i = this.array.length; i < newArray.length; ++i) {
            newArray[i] = new short[16384];
        }
        SplitArray16 splitArray16 = this;
        synchronized (splitArray16) {
            this.array = newArray;
        }
    }

    public void resizeAndClear(long newSize) {
        int oldNrOfChunks = this.array.length;
        this.resize(newSize);
        for (int i = 0; i < oldNrOfChunks; ++i) {
            Arrays.fill(this.array[i], (short)0);
        }
    }
}

